package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeDatabaseRequest(databaseName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseRequest = {
    import DescribeDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseRequest
      .builder()
      .databaseName(ResourceName.unwrap(databaseName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.DescribeDatabaseRequest.ReadOnly =
    zio.aws.timestreamwrite.model.DescribeDatabaseRequest.wrap(buildAwsValue())
}
object DescribeDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.DescribeDatabaseRequest =
      zio.aws.timestreamwrite.model.DescribeDatabaseRequest(databaseName)
    def databaseName: ResourceName
    def getDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(databaseName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseRequest
  ) extends zio.aws.timestreamwrite.model.DescribeDatabaseRequest.ReadOnly {
    override val databaseName: ResourceName =
      zio.aws.timestreamwrite.model.primitives.ResourceName(impl.databaseName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseRequest
  ): zio.aws.timestreamwrite.model.DescribeDatabaseRequest.ReadOnly =
    new Wrapper(impl)
}
