package zio.aws.timestreamwrite.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListBatchLoadTasksResponse(
    nextToken: Optional[String] = Optional.Absent,
    batchLoadTasks: Optional[
      Iterable[zio.aws.timestreamwrite.model.BatchLoadTask]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksResponse = {
    import ListBatchLoadTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        batchLoadTasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.batchLoadTasks)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.ListBatchLoadTasksResponse.ReadOnly =
    zio.aws.timestreamwrite.model.ListBatchLoadTasksResponse
      .wrap(buildAwsValue())
}
object ListBatchLoadTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.ListBatchLoadTasksResponse =
      zio.aws.timestreamwrite.model.ListBatchLoadTasksResponse(
        nextToken.map(value => value),
        batchLoadTasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def batchLoadTasks
        : Optional[List[zio.aws.timestreamwrite.model.BatchLoadTask.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getBatchLoadTasks: ZIO[Any, AwsError, List[
      zio.aws.timestreamwrite.model.BatchLoadTask.ReadOnly
    ]] = AwsError.unwrapOptionField("batchLoadTasks", batchLoadTasks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksResponse
  ) extends zio.aws.timestreamwrite.model.ListBatchLoadTasksResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val batchLoadTasks
        : Optional[List[zio.aws.timestreamwrite.model.BatchLoadTask.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.batchLoadTasks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.timestreamwrite.model.BatchLoadTask.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ListBatchLoadTasksResponse
  ): zio.aws.timestreamwrite.model.ListBatchLoadTasksResponse.ReadOnly =
    new Wrapper(impl)
}
