package zio.aws.timestreamwrite.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReportConfiguration(
    reportS3Configuration: Optional[
      zio.aws.timestreamwrite.model.ReportS3Configuration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.ReportConfiguration = {
    import ReportConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.ReportConfiguration
      .builder()
      .optionallyWith(
        reportS3Configuration.map(value => value.buildAwsValue())
      )(_.reportS3Configuration)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.ReportConfiguration.ReadOnly =
    zio.aws.timestreamwrite.model.ReportConfiguration.wrap(buildAwsValue())
}
object ReportConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.ReportConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.ReportConfiguration =
      zio.aws.timestreamwrite.model.ReportConfiguration(
        reportS3Configuration.map(value => value.asEditable)
      )
    def reportS3Configuration
        : Optional[zio.aws.timestreamwrite.model.ReportS3Configuration.ReadOnly]
    def getReportS3Configuration: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.ReportS3Configuration.ReadOnly
    ] =
      AwsError.unwrapOptionField("reportS3Configuration", reportS3Configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ReportConfiguration
  ) extends zio.aws.timestreamwrite.model.ReportConfiguration.ReadOnly {
    override val reportS3Configuration: Optional[
      zio.aws.timestreamwrite.model.ReportS3Configuration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.reportS3Configuration())
      .map(value =>
        zio.aws.timestreamwrite.model.ReportS3Configuration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ReportConfiguration
  ): zio.aws.timestreamwrite.model.ReportConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
