package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.SchemaName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MultiMeasureAttributeMapping(
    sourceColumn: SchemaName,
    targetMultiMeasureAttributeName: Optional[SchemaName] = Optional.Absent,
    measureValueType: Optional[
      zio.aws.timestreamwrite.model.ScalarMeasureValueType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.MultiMeasureAttributeMapping = {
    import MultiMeasureAttributeMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.MultiMeasureAttributeMapping
      .builder()
      .sourceColumn(SchemaName.unwrap(sourceColumn): java.lang.String)
      .optionallyWith(
        targetMultiMeasureAttributeName.map(value =>
          SchemaName.unwrap(value): java.lang.String
        )
      )(_.targetMultiMeasureAttributeName)
      .optionallyWith(measureValueType.map(value => value.unwrap))(
        _.measureValueType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.MultiMeasureAttributeMapping.ReadOnly =
    zio.aws.timestreamwrite.model.MultiMeasureAttributeMapping
      .wrap(buildAwsValue())
}
object MultiMeasureAttributeMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.MultiMeasureAttributeMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.MultiMeasureAttributeMapping =
      zio.aws.timestreamwrite.model.MultiMeasureAttributeMapping(
        sourceColumn,
        targetMultiMeasureAttributeName.map(value => value),
        measureValueType.map(value => value)
      )
    def sourceColumn: SchemaName
    def targetMultiMeasureAttributeName: Optional[SchemaName]
    def measureValueType
        : Optional[zio.aws.timestreamwrite.model.ScalarMeasureValueType]
    def getSourceColumn: ZIO[Any, Nothing, SchemaName] =
      ZIO.succeed(sourceColumn)
    def getTargetMultiMeasureAttributeName: ZIO[Any, AwsError, SchemaName] =
      AwsError.unwrapOptionField(
        "targetMultiMeasureAttributeName",
        targetMultiMeasureAttributeName
      )
    def getMeasureValueType: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.ScalarMeasureValueType
    ] = AwsError.unwrapOptionField("measureValueType", measureValueType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.MultiMeasureAttributeMapping
  ) extends zio.aws.timestreamwrite.model.MultiMeasureAttributeMapping.ReadOnly {
    override val sourceColumn: SchemaName =
      zio.aws.timestreamwrite.model.primitives.SchemaName(impl.sourceColumn())
    override val targetMultiMeasureAttributeName: Optional[SchemaName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetMultiMeasureAttributeName())
        .map(value =>
          zio.aws.timestreamwrite.model.primitives.SchemaName(value)
        )
    override val measureValueType
        : Optional[zio.aws.timestreamwrite.model.ScalarMeasureValueType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.measureValueType())
        .map(value =>
          zio.aws.timestreamwrite.model.ScalarMeasureValueType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.MultiMeasureAttributeMapping
  ): zio.aws.timestreamwrite.model.MultiMeasureAttributeMapping.ReadOnly =
    new Wrapper(impl)
}
