package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.{
  RecordVersion,
  ResourceCreateAPIName,
  ClientRequestToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateBatchLoadTaskRequest(
    clientToken: Optional[ClientRequestToken] = Optional.Absent,
    dataModelConfiguration: Optional[
      zio.aws.timestreamwrite.model.DataModelConfiguration
    ] = Optional.Absent,
    dataSourceConfiguration: zio.aws.timestreamwrite.model.DataSourceConfiguration,
    reportConfiguration: zio.aws.timestreamwrite.model.ReportConfiguration,
    targetDatabaseName: ResourceCreateAPIName,
    targetTableName: ResourceCreateAPIName,
    recordVersion: Optional[RecordVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.CreateBatchLoadTaskRequest = {
    import CreateBatchLoadTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.CreateBatchLoadTaskRequest
      .builder()
      .optionallyWith(
        clientToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .optionallyWith(
        dataModelConfiguration.map(value => value.buildAwsValue())
      )(_.dataModelConfiguration)
      .dataSourceConfiguration(dataSourceConfiguration.buildAwsValue())
      .reportConfiguration(reportConfiguration.buildAwsValue())
      .targetDatabaseName(
        ResourceCreateAPIName.unwrap(targetDatabaseName): java.lang.String
      )
      .targetTableName(
        ResourceCreateAPIName.unwrap(targetTableName): java.lang.String
      )
      .optionallyWith(
        recordVersion.map(value => RecordVersion.unwrap(value): java.lang.Long)
      )(_.recordVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.CreateBatchLoadTaskRequest.ReadOnly =
    zio.aws.timestreamwrite.model.CreateBatchLoadTaskRequest
      .wrap(buildAwsValue())
}
object CreateBatchLoadTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.CreateBatchLoadTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.CreateBatchLoadTaskRequest =
      zio.aws.timestreamwrite.model.CreateBatchLoadTaskRequest(
        clientToken.map(value => value),
        dataModelConfiguration.map(value => value.asEditable),
        dataSourceConfiguration.asEditable,
        reportConfiguration.asEditable,
        targetDatabaseName,
        targetTableName,
        recordVersion.map(value => value)
      )
    def clientToken: Optional[ClientRequestToken]
    def dataModelConfiguration: Optional[
      zio.aws.timestreamwrite.model.DataModelConfiguration.ReadOnly
    ]
    def dataSourceConfiguration
        : zio.aws.timestreamwrite.model.DataSourceConfiguration.ReadOnly
    def reportConfiguration
        : zio.aws.timestreamwrite.model.ReportConfiguration.ReadOnly
    def targetDatabaseName: ResourceCreateAPIName
    def targetTableName: ResourceCreateAPIName
    def recordVersion: Optional[RecordVersion]
    def getClientToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDataModelConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamwrite.model.DataModelConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataModelConfiguration",
      dataModelConfiguration
    )
    def getDataSourceConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.timestreamwrite.model.DataSourceConfiguration.ReadOnly
    ] = ZIO.succeed(dataSourceConfiguration)
    def getReportConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.timestreamwrite.model.ReportConfiguration.ReadOnly
    ] = ZIO.succeed(reportConfiguration)
    def getTargetDatabaseName: ZIO[Any, Nothing, ResourceCreateAPIName] =
      ZIO.succeed(targetDatabaseName)
    def getTargetTableName: ZIO[Any, Nothing, ResourceCreateAPIName] =
      ZIO.succeed(targetTableName)
    def getRecordVersion: ZIO[Any, AwsError, RecordVersion] =
      AwsError.unwrapOptionField("recordVersion", recordVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.CreateBatchLoadTaskRequest
  ) extends zio.aws.timestreamwrite.model.CreateBatchLoadTaskRequest.ReadOnly {
    override val clientToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientToken())
        .map(value =>
          zio.aws.timestreamwrite.model.primitives.ClientRequestToken(value)
        )
    override val dataModelConfiguration: Optional[
      zio.aws.timestreamwrite.model.DataModelConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataModelConfiguration())
      .map(value =>
        zio.aws.timestreamwrite.model.DataModelConfiguration.wrap(value)
      )
    override val dataSourceConfiguration
        : zio.aws.timestreamwrite.model.DataSourceConfiguration.ReadOnly =
      zio.aws.timestreamwrite.model.DataSourceConfiguration
        .wrap(impl.dataSourceConfiguration())
    override val reportConfiguration
        : zio.aws.timestreamwrite.model.ReportConfiguration.ReadOnly =
      zio.aws.timestreamwrite.model.ReportConfiguration
        .wrap(impl.reportConfiguration())
    override val targetDatabaseName: ResourceCreateAPIName =
      zio.aws.timestreamwrite.model.primitives
        .ResourceCreateAPIName(impl.targetDatabaseName())
    override val targetTableName: ResourceCreateAPIName =
      zio.aws.timestreamwrite.model.primitives
        .ResourceCreateAPIName(impl.targetTableName())
    override val recordVersion: Optional[RecordVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.recordVersion())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.RecordVersion(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.CreateBatchLoadTaskRequest
  ): zio.aws.timestreamwrite.model.CreateBatchLoadTaskRequest.ReadOnly =
    new Wrapper(impl)
}
