package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.{S3ObjectKey, S3BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataModelS3Configuration(
    bucketName: Optional[S3BucketName] = Optional.Absent,
    objectKey: Optional[S3ObjectKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.DataModelS3Configuration = {
    import DataModelS3Configuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.DataModelS3Configuration
      .builder()
      .optionallyWith(
        bucketName.map(value => S3BucketName.unwrap(value): java.lang.String)
      )(_.bucketName)
      .optionallyWith(
        objectKey.map(value => S3ObjectKey.unwrap(value): java.lang.String)
      )(_.objectKey)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.DataModelS3Configuration.ReadOnly =
    zio.aws.timestreamwrite.model.DataModelS3Configuration.wrap(buildAwsValue())
}
object DataModelS3Configuration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.DataModelS3Configuration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.DataModelS3Configuration =
      zio.aws.timestreamwrite.model.DataModelS3Configuration(
        bucketName.map(value => value),
        objectKey.map(value => value)
      )
    def bucketName: Optional[S3BucketName]
    def objectKey: Optional[S3ObjectKey]
    def getBucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getObjectKey: ZIO[Any, AwsError, S3ObjectKey] =
      AwsError.unwrapOptionField("objectKey", objectKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DataModelS3Configuration
  ) extends zio.aws.timestreamwrite.model.DataModelS3Configuration.ReadOnly {
    override val bucketName: Optional[S3BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketName())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.S3BucketName(value)
      )
    override val objectKey: Optional[S3ObjectKey] = zio.aws.core.internal
      .optionalFromNullable(impl.objectKey())
      .map(value => zio.aws.timestreamwrite.model.primitives.S3ObjectKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DataModelS3Configuration
  ): zio.aws.timestreamwrite.model.DataModelS3Configuration.ReadOnly =
    new Wrapper(impl)
}
