package zio.aws.timestreamwrite.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDatabaseResponse(
    database: Optional[zio.aws.timestreamwrite.model.Database] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseResponse = {
    import DescribeDatabaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseResponse
      .builder()
      .optionallyWith(database.map(value => value.buildAwsValue()))(_.database)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.DescribeDatabaseResponse.ReadOnly =
    zio.aws.timestreamwrite.model.DescribeDatabaseResponse.wrap(buildAwsValue())
}
object DescribeDatabaseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.DescribeDatabaseResponse =
      zio.aws.timestreamwrite.model
        .DescribeDatabaseResponse(database.map(value => value.asEditable))
    def database: Optional[zio.aws.timestreamwrite.model.Database.ReadOnly]
    def getDatabase
        : ZIO[Any, AwsError, zio.aws.timestreamwrite.model.Database.ReadOnly] =
      AwsError.unwrapOptionField("database", database)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseResponse
  ) extends zio.aws.timestreamwrite.model.DescribeDatabaseResponse.ReadOnly {
    override val database
        : Optional[zio.aws.timestreamwrite.model.Database.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.database())
        .map(value => zio.aws.timestreamwrite.model.Database.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.DescribeDatabaseResponse
  ): zio.aws.timestreamwrite.model.DescribeDatabaseResponse.ReadOnly =
    new Wrapper(impl)
}
