package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.{StringValue2048, SchemaName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class MeasureValue(
    name: SchemaName,
    value: StringValue2048,
    `type`: zio.aws.timestreamwrite.model.MeasureValueType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.MeasureValue = {
    import MeasureValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.MeasureValue
      .builder()
      .name(SchemaName.unwrap(name): java.lang.String)
      .value(StringValue2048.unwrap(value): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.MeasureValue.ReadOnly =
    zio.aws.timestreamwrite.model.MeasureValue.wrap(buildAwsValue())
}
object MeasureValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.MeasureValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.MeasureValue =
      zio.aws.timestreamwrite.model.MeasureValue(name, value, `type`)
    def name: SchemaName
    def value: StringValue2048
    def `type`: zio.aws.timestreamwrite.model.MeasureValueType
    def getName: ZIO[Any, Nothing, SchemaName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, StringValue2048] = ZIO.succeed(value)
    def getType
        : ZIO[Any, Nothing, zio.aws.timestreamwrite.model.MeasureValueType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.MeasureValue
  ) extends zio.aws.timestreamwrite.model.MeasureValue.ReadOnly {
    override val name: SchemaName =
      zio.aws.timestreamwrite.model.primitives.SchemaName(impl.name())
    override val value: StringValue2048 =
      zio.aws.timestreamwrite.model.primitives.StringValue2048(impl.value())
    override val `type`: zio.aws.timestreamwrite.model.MeasureValueType =
      zio.aws.timestreamwrite.model.MeasureValueType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.MeasureValue
  ): zio.aws.timestreamwrite.model.MeasureValue.ReadOnly = new Wrapper(impl)
}
