package zio.aws.timestreamwrite.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateDatabaseResponse(
    database: Option[zio.aws.timestreamwrite.model.Database] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseResponse = {
    import UpdateDatabaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseResponse
      .builder()
      .optionallyWith(database.map(value => value.buildAwsValue()))(_.database)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamwrite.model.UpdateDatabaseResponse.ReadOnly =
    zio.aws.timestreamwrite.model.UpdateDatabaseResponse.wrap(buildAwsValue())
}
object UpdateDatabaseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.UpdateDatabaseResponse =
      zio.aws.timestreamwrite.model
        .UpdateDatabaseResponse(database.map(value => value.asEditable))
    def database: Option[zio.aws.timestreamwrite.model.Database.ReadOnly]
    def getDatabase
        : ZIO[Any, AwsError, zio.aws.timestreamwrite.model.Database.ReadOnly] =
      AwsError.unwrapOptionField("database", database)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseResponse
  ) extends zio.aws.timestreamwrite.model.UpdateDatabaseResponse.ReadOnly {
    override val database
        : Option[zio.aws.timestreamwrite.model.Database.ReadOnly] = scala
      .Option(impl.database())
      .map(value => zio.aws.timestreamwrite.model.Database.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.UpdateDatabaseResponse
  ): zio.aws.timestreamwrite.model.UpdateDatabaseResponse.ReadOnly =
    new Wrapper(impl)
}
