package zio.aws.timestreamwrite.model
import scala.jdk.CollectionConverters._
sealed trait S3EncryptionOption {
  def unwrap
      : software.amazon.awssdk.services.timestreamwrite.model.S3EncryptionOption
}
object S3EncryptionOption {
  def wrap(
      value: software.amazon.awssdk.services.timestreamwrite.model.S3EncryptionOption
  ): zio.aws.timestreamwrite.model.S3EncryptionOption = value match {
    case software.amazon.awssdk.services.timestreamwrite.model.S3EncryptionOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.timestreamwrite.model.S3EncryptionOption.SSE_S3 =>
      val r = SSE_S3
      r
    case software.amazon.awssdk.services.timestreamwrite.model.S3EncryptionOption.SSE_KMS =>
      val r = SSE_KMS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.timestreamwrite.model.S3EncryptionOption {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.S3EncryptionOption =
      software.amazon.awssdk.services.timestreamwrite.model.S3EncryptionOption.UNKNOWN_TO_SDK_VERSION
  }
  case object SSE_S3 extends zio.aws.timestreamwrite.model.S3EncryptionOption {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.S3EncryptionOption =
      software.amazon.awssdk.services.timestreamwrite.model.S3EncryptionOption.SSE_S3
  }
  case object SSE_KMS extends zio.aws.timestreamwrite.model.S3EncryptionOption {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.S3EncryptionOption =
      software.amazon.awssdk.services.timestreamwrite.model.S3EncryptionOption.SSE_KMS
  }
}
