package zio.aws.timestreamwrite.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDatabasesResponse(
    databases: Option[Iterable[zio.aws.timestreamwrite.model.Database]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesResponse = {
    import ListDatabasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesResponse
      .builder()
      .optionallyWith(
        databases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.databases)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.ListDatabasesResponse.ReadOnly =
    zio.aws.timestreamwrite.model.ListDatabasesResponse.wrap(buildAwsValue())
}
object ListDatabasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.ListDatabasesResponse =
      zio.aws.timestreamwrite.model.ListDatabasesResponse(
        databases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def databases: Option[List[zio.aws.timestreamwrite.model.Database.ReadOnly]]
    def nextToken: Option[String]
    def getDatabases: ZIO[Any, AwsError, List[
      zio.aws.timestreamwrite.model.Database.ReadOnly
    ]] = AwsError.unwrapOptionField("databases", databases)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesResponse
  ) extends zio.aws.timestreamwrite.model.ListDatabasesResponse.ReadOnly {
    override val databases
        : Option[List[zio.aws.timestreamwrite.model.Database.ReadOnly]] = scala
      .Option(impl.databases())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.timestreamwrite.model.Database.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.ListDatabasesResponse
  ): zio.aws.timestreamwrite.model.ListDatabasesResponse.ReadOnly = new Wrapper(
    impl
  )
}
