package zio.aws.timestreamwrite.model
import scala.jdk.CollectionConverters._
sealed trait TimeUnit {
  def unwrap: software.amazon.awssdk.services.timestreamwrite.model.TimeUnit
}
object TimeUnit {
  def wrap(
      value: software.amazon.awssdk.services.timestreamwrite.model.TimeUnit
  ): zio.aws.timestreamwrite.model.TimeUnit = value match {
    case software.amazon.awssdk.services.timestreamwrite.model.TimeUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.timestreamwrite.model.TimeUnit.MILLISECONDS =>
      val r = MILLISECONDS
      r
    case software.amazon.awssdk.services.timestreamwrite.model.TimeUnit.SECONDS =>
      val r = SECONDS
      r
    case software.amazon.awssdk.services.timestreamwrite.model.TimeUnit.MICROSECONDS =>
      val r = MICROSECONDS
      r
    case software.amazon.awssdk.services.timestreamwrite.model.TimeUnit.NANOSECONDS =>
      val r = NANOSECONDS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.timestreamwrite.model.TimeUnit {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.TimeUnit =
      software.amazon.awssdk.services.timestreamwrite.model.TimeUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object MILLISECONDS extends zio.aws.timestreamwrite.model.TimeUnit {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.TimeUnit =
      software.amazon.awssdk.services.timestreamwrite.model.TimeUnit.MILLISECONDS
  }
  case object SECONDS extends zio.aws.timestreamwrite.model.TimeUnit {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.TimeUnit =
      software.amazon.awssdk.services.timestreamwrite.model.TimeUnit.SECONDS
  }
  case object MICROSECONDS extends zio.aws.timestreamwrite.model.TimeUnit {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.TimeUnit =
      software.amazon.awssdk.services.timestreamwrite.model.TimeUnit.MICROSECONDS
  }
  case object NANOSECONDS extends zio.aws.timestreamwrite.model.TimeUnit {
    override def unwrap
        : software.amazon.awssdk.services.timestreamwrite.model.TimeUnit =
      software.amazon.awssdk.services.timestreamwrite.model.TimeUnit.NANOSECONDS
  }
}
