package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.{
  RecordVersion,
  StringValue256,
  StringValue2048,
  SchemaName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Record(
    dimensions: Option[Iterable[zio.aws.timestreamwrite.model.Dimension]] =
      None,
    measureName: Option[SchemaName] = None,
    measureValue: Option[StringValue2048] = None,
    measureValueType: Option[zio.aws.timestreamwrite.model.MeasureValueType] =
      None,
    time: Option[StringValue256] = None,
    timeUnit: Option[zio.aws.timestreamwrite.model.TimeUnit] = None,
    version: Option[RecordVersion] = None,
    measureValues: Option[
      Iterable[zio.aws.timestreamwrite.model.MeasureValue]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.Record = {
    import Record.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.Record
      .builder()
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(
        measureName.map(value => SchemaName.unwrap(value): java.lang.String)
      )(_.measureName)
      .optionallyWith(
        measureValue.map(value =>
          StringValue2048.unwrap(value): java.lang.String
        )
      )(_.measureValue)
      .optionallyWith(measureValueType.map(value => value.unwrap))(
        _.measureValueType
      )
      .optionallyWith(
        time.map(value => StringValue256.unwrap(value): java.lang.String)
      )(_.time)
      .optionallyWith(timeUnit.map(value => value.unwrap))(_.timeUnit)
      .optionallyWith(
        version.map(value => RecordVersion.unwrap(value): java.lang.Long)
      )(_.version)
      .optionallyWith(
        measureValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.measureValues)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.Record.ReadOnly =
    zio.aws.timestreamwrite.model.Record.wrap(buildAwsValue())
}
object Record {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.Record
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.Record =
      zio.aws.timestreamwrite.model.Record(
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        measureName.map(value => value),
        measureValue.map(value => value),
        measureValueType.map(value => value),
        time.map(value => value),
        timeUnit.map(value => value),
        version.map(value => value),
        measureValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dimensions
        : Option[List[zio.aws.timestreamwrite.model.Dimension.ReadOnly]]
    def measureName: Option[SchemaName]
    def measureValue: Option[StringValue2048]
    def measureValueType: Option[zio.aws.timestreamwrite.model.MeasureValueType]
    def time: Option[StringValue256]
    def timeUnit: Option[zio.aws.timestreamwrite.model.TimeUnit]
    def version: Option[RecordVersion]
    def measureValues
        : Option[List[zio.aws.timestreamwrite.model.MeasureValue.ReadOnly]]
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.timestreamwrite.model.Dimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getMeasureName: ZIO[Any, AwsError, SchemaName] =
      AwsError.unwrapOptionField("measureName", measureName)
    def getMeasureValue: ZIO[Any, AwsError, StringValue2048] =
      AwsError.unwrapOptionField("measureValue", measureValue)
    def getMeasureValueType
        : ZIO[Any, AwsError, zio.aws.timestreamwrite.model.MeasureValueType] =
      AwsError.unwrapOptionField("measureValueType", measureValueType)
    def getTime: ZIO[Any, AwsError, StringValue256] =
      AwsError.unwrapOptionField("time", time)
    def getTimeUnit
        : ZIO[Any, AwsError, zio.aws.timestreamwrite.model.TimeUnit] =
      AwsError.unwrapOptionField("timeUnit", timeUnit)
    def getVersion: ZIO[Any, AwsError, RecordVersion] =
      AwsError.unwrapOptionField("version", version)
    def getMeasureValues: ZIO[Any, AwsError, List[
      zio.aws.timestreamwrite.model.MeasureValue.ReadOnly
    ]] = AwsError.unwrapOptionField("measureValues", measureValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.Record
  ) extends zio.aws.timestreamwrite.model.Record.ReadOnly {
    override val dimensions
        : Option[List[zio.aws.timestreamwrite.model.Dimension.ReadOnly]] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.timestreamwrite.model.Dimension.wrap(item)
        }.toList
      )
    override val measureName: Option[SchemaName] = scala
      .Option(impl.measureName())
      .map(value => zio.aws.timestreamwrite.model.primitives.SchemaName(value))
    override val measureValue: Option[StringValue2048] = scala
      .Option(impl.measureValue())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.StringValue2048(value)
      )
    override val measureValueType
        : Option[zio.aws.timestreamwrite.model.MeasureValueType] = scala
      .Option(impl.measureValueType())
      .map(value => zio.aws.timestreamwrite.model.MeasureValueType.wrap(value))
    override val time: Option[StringValue256] = scala
      .Option(impl.time())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.StringValue256(value)
      )
    override val timeUnit: Option[zio.aws.timestreamwrite.model.TimeUnit] =
      scala
        .Option(impl.timeUnit())
        .map(value => zio.aws.timestreamwrite.model.TimeUnit.wrap(value))
    override val version: Option[RecordVersion] = scala
      .Option(impl.version())
      .map(value =>
        zio.aws.timestreamwrite.model.primitives.RecordVersion(value)
      )
    override val measureValues
        : Option[List[zio.aws.timestreamwrite.model.MeasureValue.ReadOnly]] =
      scala
        .Option(impl.measureValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.timestreamwrite.model.MeasureValue.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.Record
  ): zio.aws.timestreamwrite.model.Record.ReadOnly = new Wrapper(impl)
}
