package zio.aws.timestreamwrite.model
import zio.aws.timestreamwrite.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RecordsIngested(
    total: Option[Integer] = None,
    memoryStore: Option[Integer] = None,
    magneticStore: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamwrite.model.RecordsIngested = {
    import RecordsIngested.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamwrite.model.RecordsIngested
      .builder()
      .optionallyWith(
        total.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.total)
      .optionallyWith(
        memoryStore.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.memoryStore)
      .optionallyWith(
        magneticStore.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.magneticStore)
      .build()
  }
  def asReadOnly: zio.aws.timestreamwrite.model.RecordsIngested.ReadOnly =
    zio.aws.timestreamwrite.model.RecordsIngested.wrap(buildAwsValue())
}
object RecordsIngested {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamwrite.model.RecordsIngested
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamwrite.model.RecordsIngested =
      zio.aws.timestreamwrite.model.RecordsIngested(
        total.map(value => value),
        memoryStore.map(value => value),
        magneticStore.map(value => value)
      )
    def total: Option[Integer]
    def memoryStore: Option[Integer]
    def magneticStore: Option[Integer]
    def getTotal: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("total", total)
    def getMemoryStore: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("memoryStore", memoryStore)
    def getMagneticStore: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("magneticStore", magneticStore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamwrite.model.RecordsIngested
  ) extends zio.aws.timestreamwrite.model.RecordsIngested.ReadOnly {
    override val total: Option[Integer] = scala
      .Option(impl.total())
      .map(value => zio.aws.timestreamwrite.model.primitives.Integer(value))
    override val memoryStore: Option[Integer] = scala
      .Option(impl.memoryStore())
      .map(value => zio.aws.timestreamwrite.model.primitives.Integer(value))
    override val magneticStore: Option[Integer] = scala
      .Option(impl.magneticStore())
      .map(value => zio.aws.timestreamwrite.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamwrite.model.RecordsIngested
  ): zio.aws.timestreamwrite.model.RecordsIngested.ReadOnly = new Wrapper(impl)
}
