package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.{NullableBoolean, ResourceName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SelectColumn(
    name: Optional[String] = Optional.Absent,
    `type`: Optional[zio.aws.timestreamquery.model.Type] = Optional.Absent,
    databaseName: Optional[ResourceName] = Optional.Absent,
    tableName: Optional[ResourceName] = Optional.Absent,
    aliased: Optional[NullableBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.SelectColumn = {
    import SelectColumn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.SelectColumn
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(`type`.map(value => value.buildAwsValue()))(_.`type`)
      .optionallyWith(
        databaseName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.databaseName)
      .optionallyWith(
        tableName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(aliased.map(value => value: java.lang.Boolean))(_.aliased)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.SelectColumn.ReadOnly =
    zio.aws.timestreamquery.model.SelectColumn.wrap(buildAwsValue())
}
object SelectColumn {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.SelectColumn
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.SelectColumn =
      zio.aws.timestreamquery.model.SelectColumn(
        name.map(value => value),
        `type`.map(value => value.asEditable),
        databaseName.map(value => value),
        tableName.map(value => value),
        aliased.map(value => value)
      )
    def name: Optional[String]
    def `type`: Optional[zio.aws.timestreamquery.model.Type.ReadOnly]
    def databaseName: Optional[ResourceName]
    def tableName: Optional[ResourceName]
    def aliased: Optional[NullableBoolean]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getType
        : ZIO[Any, AwsError, zio.aws.timestreamquery.model.Type.ReadOnly] =
      AwsError.unwrapOptionField("type", `type`)
    def getDatabaseName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getTableName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getAliased: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("aliased", aliased)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.SelectColumn
  ) extends zio.aws.timestreamquery.model.SelectColumn.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val `type`: Optional[zio.aws.timestreamquery.model.Type.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.timestreamquery.model.Type.wrap(value))
    override val databaseName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value =>
        zio.aws.timestreamquery.model.primitives.ResourceName(value)
      )
    override val tableName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value =>
        zio.aws.timestreamquery.model.primitives.ResourceName(value)
      )
    override val aliased: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.aliased())
      .map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.SelectColumn
  ): zio.aws.timestreamquery.model.SelectColumn.ReadOnly = new Wrapper(impl)
}
