package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.QueryString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PrepareQueryResponse(
    queryString: QueryString,
    columns: Iterable[zio.aws.timestreamquery.model.SelectColumn],
    parameters: Iterable[zio.aws.timestreamquery.model.ParameterMapping]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.PrepareQueryResponse = {
    import PrepareQueryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.PrepareQueryResponse
      .builder()
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .columns(columns.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .parameters(parameters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.PrepareQueryResponse.ReadOnly =
    zio.aws.timestreamquery.model.PrepareQueryResponse.wrap(buildAwsValue())
}
object PrepareQueryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.PrepareQueryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.PrepareQueryResponse =
      zio.aws.timestreamquery.model.PrepareQueryResponse(
        queryString,
        columns.map { item =>
          item.asEditable
        },
        parameters.map { item =>
          item.asEditable
        }
      )
    def queryString: QueryString
    def columns: List[zio.aws.timestreamquery.model.SelectColumn.ReadOnly]
    def parameters
        : List[zio.aws.timestreamquery.model.ParameterMapping.ReadOnly]
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getColumns: ZIO[Any, Nothing, List[
      zio.aws.timestreamquery.model.SelectColumn.ReadOnly
    ]] = ZIO.succeed(columns)
    def getParameters: ZIO[Any, Nothing, List[
      zio.aws.timestreamquery.model.ParameterMapping.ReadOnly
    ]] = ZIO.succeed(parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.PrepareQueryResponse
  ) extends zio.aws.timestreamquery.model.PrepareQueryResponse.ReadOnly {
    override val queryString: QueryString =
      zio.aws.timestreamquery.model.primitives.QueryString(impl.queryString())
    override val columns
        : List[zio.aws.timestreamquery.model.SelectColumn.ReadOnly] = impl
      .columns()
      .asScala
      .map { item =>
        zio.aws.timestreamquery.model.SelectColumn.wrap(item)
      }
      .toList
    override val parameters
        : List[zio.aws.timestreamquery.model.ParameterMapping.ReadOnly] = impl
      .parameters()
      .asScala
      .map { item =>
        zio.aws.timestreamquery.model.ParameterMapping.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.PrepareQueryResponse
  ): zio.aws.timestreamquery.model.PrepareQueryResponse.ReadOnly = new Wrapper(
    impl
  )
}
