package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.{
  S3ObjectKeyPrefix,
  S3BucketName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3Configuration(
    bucketName: S3BucketName,
    objectKeyPrefix: Optional[S3ObjectKeyPrefix] = Optional.Absent,
    encryptionOption: Optional[
      zio.aws.timestreamquery.model.S3EncryptionOption
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.S3Configuration = {
    import S3Configuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.S3Configuration
      .builder()
      .bucketName(S3BucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        objectKeyPrefix.map(value =>
          S3ObjectKeyPrefix.unwrap(value): java.lang.String
        )
      )(_.objectKeyPrefix)
      .optionallyWith(encryptionOption.map(value => value.unwrap))(
        _.encryptionOption
      )
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.S3Configuration.ReadOnly =
    zio.aws.timestreamquery.model.S3Configuration.wrap(buildAwsValue())
}
object S3Configuration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.S3Configuration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.S3Configuration =
      zio.aws.timestreamquery.model.S3Configuration(
        bucketName,
        objectKeyPrefix.map(value => value),
        encryptionOption.map(value => value)
      )
    def bucketName: S3BucketName
    def objectKeyPrefix: Optional[S3ObjectKeyPrefix]
    def encryptionOption
        : Optional[zio.aws.timestreamquery.model.S3EncryptionOption]
    def getBucketName: ZIO[Any, Nothing, S3BucketName] = ZIO.succeed(bucketName)
    def getObjectKeyPrefix: ZIO[Any, AwsError, S3ObjectKeyPrefix] =
      AwsError.unwrapOptionField("objectKeyPrefix", objectKeyPrefix)
    def getEncryptionOption
        : ZIO[Any, AwsError, zio.aws.timestreamquery.model.S3EncryptionOption] =
      AwsError.unwrapOptionField("encryptionOption", encryptionOption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.S3Configuration
  ) extends zio.aws.timestreamquery.model.S3Configuration.ReadOnly {
    override val bucketName: S3BucketName =
      zio.aws.timestreamquery.model.primitives.S3BucketName(impl.bucketName())
    override val objectKeyPrefix: Optional[S3ObjectKeyPrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectKeyPrefix())
        .map(value =>
          zio.aws.timestreamquery.model.primitives.S3ObjectKeyPrefix(value)
        )
    override val encryptionOption
        : Optional[zio.aws.timestreamquery.model.S3EncryptionOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionOption())
        .map(value =>
          zio.aws.timestreamquery.model.S3EncryptionOption.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.S3Configuration
  ): zio.aws.timestreamquery.model.S3Configuration.ReadOnly = new Wrapper(impl)
}
