package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.SchemaName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MixedMeasureMapping(
    measureName: Optional[SchemaName] = Optional.Absent,
    sourceColumn: Optional[SchemaName] = Optional.Absent,
    targetMeasureName: Optional[SchemaName] = Optional.Absent,
    measureValueType: zio.aws.timestreamquery.model.MeasureValueType,
    multiMeasureAttributeMappings: Optional[
      Iterable[zio.aws.timestreamquery.model.MultiMeasureAttributeMapping]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.MixedMeasureMapping = {
    import MixedMeasureMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.MixedMeasureMapping
      .builder()
      .optionallyWith(
        measureName.map(value => SchemaName.unwrap(value): java.lang.String)
      )(_.measureName)
      .optionallyWith(
        sourceColumn.map(value => SchemaName.unwrap(value): java.lang.String)
      )(_.sourceColumn)
      .optionallyWith(
        targetMeasureName.map(value =>
          SchemaName.unwrap(value): java.lang.String
        )
      )(_.targetMeasureName)
      .measureValueType(measureValueType.unwrap)
      .optionallyWith(
        multiMeasureAttributeMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.multiMeasureAttributeMappings)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.MixedMeasureMapping.ReadOnly =
    zio.aws.timestreamquery.model.MixedMeasureMapping.wrap(buildAwsValue())
}
object MixedMeasureMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.MixedMeasureMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.MixedMeasureMapping =
      zio.aws.timestreamquery.model.MixedMeasureMapping(
        measureName.map(value => value),
        sourceColumn.map(value => value),
        targetMeasureName.map(value => value),
        measureValueType,
        multiMeasureAttributeMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def measureName: Optional[SchemaName]
    def sourceColumn: Optional[SchemaName]
    def targetMeasureName: Optional[SchemaName]
    def measureValueType: zio.aws.timestreamquery.model.MeasureValueType
    def multiMeasureAttributeMappings: Optional[
      List[zio.aws.timestreamquery.model.MultiMeasureAttributeMapping.ReadOnly]
    ]
    def getMeasureName: ZIO[Any, AwsError, SchemaName] =
      AwsError.unwrapOptionField("measureName", measureName)
    def getSourceColumn: ZIO[Any, AwsError, SchemaName] =
      AwsError.unwrapOptionField("sourceColumn", sourceColumn)
    def getTargetMeasureName: ZIO[Any, AwsError, SchemaName] =
      AwsError.unwrapOptionField("targetMeasureName", targetMeasureName)
    def getMeasureValueType
        : ZIO[Any, Nothing, zio.aws.timestreamquery.model.MeasureValueType] =
      ZIO.succeed(measureValueType)
    def getMultiMeasureAttributeMappings: ZIO[Any, AwsError, List[
      zio.aws.timestreamquery.model.MultiMeasureAttributeMapping.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "multiMeasureAttributeMappings",
      multiMeasureAttributeMappings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.MixedMeasureMapping
  ) extends zio.aws.timestreamquery.model.MixedMeasureMapping.ReadOnly {
    override val measureName: Optional[SchemaName] = zio.aws.core.internal
      .optionalFromNullable(impl.measureName())
      .map(value => zio.aws.timestreamquery.model.primitives.SchemaName(value))
    override val sourceColumn: Optional[SchemaName] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceColumn())
      .map(value => zio.aws.timestreamquery.model.primitives.SchemaName(value))
    override val targetMeasureName: Optional[SchemaName] = zio.aws.core.internal
      .optionalFromNullable(impl.targetMeasureName())
      .map(value => zio.aws.timestreamquery.model.primitives.SchemaName(value))
    override val measureValueType
        : zio.aws.timestreamquery.model.MeasureValueType =
      zio.aws.timestreamquery.model.MeasureValueType
        .wrap(impl.measureValueType())
    override val multiMeasureAttributeMappings: Optional[
      List[zio.aws.timestreamquery.model.MultiMeasureAttributeMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.multiMeasureAttributeMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.timestreamquery.model.MultiMeasureAttributeMapping.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.MixedMeasureMapping
  ): zio.aws.timestreamquery.model.MixedMeasureMapping.ReadOnly = new Wrapper(
    impl
  )
}
