package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.SchemaName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DimensionMapping(
    name: SchemaName,
    dimensionValueType: zio.aws.timestreamquery.model.DimensionValueType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.DimensionMapping = {
    import DimensionMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.DimensionMapping
      .builder()
      .name(SchemaName.unwrap(name): java.lang.String)
      .dimensionValueType(dimensionValueType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.DimensionMapping.ReadOnly =
    zio.aws.timestreamquery.model.DimensionMapping.wrap(buildAwsValue())
}
object DimensionMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.DimensionMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.DimensionMapping =
      zio.aws.timestreamquery.model.DimensionMapping(name, dimensionValueType)
    def name: SchemaName
    def dimensionValueType: zio.aws.timestreamquery.model.DimensionValueType
    def getName: ZIO[Any, Nothing, SchemaName] = ZIO.succeed(name)
    def getDimensionValueType
        : ZIO[Any, Nothing, zio.aws.timestreamquery.model.DimensionValueType] =
      ZIO.succeed(dimensionValueType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.DimensionMapping
  ) extends zio.aws.timestreamquery.model.DimensionMapping.ReadOnly {
    override val name: SchemaName =
      zio.aws.timestreamquery.model.primitives.SchemaName(impl.name())
    override val dimensionValueType
        : zio.aws.timestreamquery.model.DimensionValueType =
      zio.aws.timestreamquery.model.DimensionValueType
        .wrap(impl.dimensionValueType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.DimensionMapping
  ): zio.aws.timestreamquery.model.DimensionMapping.ReadOnly = new Wrapper(impl)
}
