package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.{S3ObjectKey, S3BucketName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3ReportLocation(
    bucketName: Optional[S3BucketName] = Optional.Absent,
    objectKey: Optional[S3ObjectKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.S3ReportLocation = {
    import S3ReportLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.S3ReportLocation
      .builder()
      .optionallyWith(
        bucketName.map(value => S3BucketName.unwrap(value): java.lang.String)
      )(_.bucketName)
      .optionallyWith(
        objectKey.map(value => S3ObjectKey.unwrap(value): java.lang.String)
      )(_.objectKey)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.S3ReportLocation.ReadOnly =
    zio.aws.timestreamquery.model.S3ReportLocation.wrap(buildAwsValue())
}
object S3ReportLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.S3ReportLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.S3ReportLocation =
      zio.aws.timestreamquery.model.S3ReportLocation(
        bucketName.map(value => value),
        objectKey.map(value => value)
      )
    def bucketName: Optional[S3BucketName]
    def objectKey: Optional[S3ObjectKey]
    def getBucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getObjectKey: ZIO[Any, AwsError, S3ObjectKey] =
      AwsError.unwrapOptionField("objectKey", objectKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.S3ReportLocation
  ) extends zio.aws.timestreamquery.model.S3ReportLocation.ReadOnly {
    override val bucketName: Optional[S3BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketName())
      .map(value =>
        zio.aws.timestreamquery.model.primitives.S3BucketName(value)
      )
    override val objectKey: Optional[S3ObjectKey] = zio.aws.core.internal
      .optionalFromNullable(impl.objectKey())
      .map(value => zio.aws.timestreamquery.model.primitives.S3ObjectKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.S3ReportLocation
  ): zio.aws.timestreamquery.model.S3ReportLocation.ReadOnly = new Wrapper(impl)
}
