package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.AmazonResourceName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateScheduledQueryResponse(arn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryResponse = {
    import CreateScheduledQueryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryResponse
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.CreateScheduledQueryResponse.ReadOnly =
    zio.aws.timestreamquery.model.CreateScheduledQueryResponse
      .wrap(buildAwsValue())
}
object CreateScheduledQueryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.CreateScheduledQueryResponse =
      zio.aws.timestreamquery.model.CreateScheduledQueryResponse(arn)
    def arn: AmazonResourceName
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryResponse
  ) extends zio.aws.timestreamquery.model.CreateScheduledQueryResponse.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.timestreamquery.model.primitives.AmazonResourceName(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryResponse
  ): zio.aws.timestreamquery.model.CreateScheduledQueryResponse.ReadOnly =
    new Wrapper(impl)
}
