package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.NextTagsForResourceResultsToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    tags: Iterable[zio.aws.timestreamquery.model.Tag],
    nextToken: Optional[NextTagsForResourceResultsToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceResponse
      .builder()
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value =>
          NextTagsForResourceResultsToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.timestreamquery.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.ListTagsForResourceResponse =
      zio.aws.timestreamquery.model.ListTagsForResourceResponse(
        tags.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def tags: List[zio.aws.timestreamquery.model.Tag.ReadOnly]
    def nextToken: Optional[NextTagsForResourceResultsToken]
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.timestreamquery.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
    def getNextToken: ZIO[Any, AwsError, NextTagsForResourceResultsToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceResponse
  ) extends zio.aws.timestreamquery.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: List[zio.aws.timestreamquery.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.timestreamquery.model.Tag.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextTagsForResourceResultsToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.timestreamquery.model.primitives
            .NextTagsForResourceResultsToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceResponse
  ): zio.aws.timestreamquery.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
