package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ErrorReportLocation(
    s3ReportLocation: Optional[zio.aws.timestreamquery.model.S3ReportLocation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.ErrorReportLocation = {
    import ErrorReportLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.ErrorReportLocation
      .builder()
      .optionallyWith(s3ReportLocation.map(value => value.buildAwsValue()))(
        _.s3ReportLocation
      )
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.ErrorReportLocation.ReadOnly =
    zio.aws.timestreamquery.model.ErrorReportLocation.wrap(buildAwsValue())
}
object ErrorReportLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.ErrorReportLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.ErrorReportLocation =
      zio.aws.timestreamquery.model
        .ErrorReportLocation(s3ReportLocation.map(value => value.asEditable))
    def s3ReportLocation
        : Optional[zio.aws.timestreamquery.model.S3ReportLocation.ReadOnly]
    def getS3ReportLocation: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.S3ReportLocation.ReadOnly
    ] = AwsError.unwrapOptionField("s3ReportLocation", s3ReportLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.ErrorReportLocation
  ) extends zio.aws.timestreamquery.model.ErrorReportLocation.ReadOnly {
    override val s3ReportLocation
        : Optional[zio.aws.timestreamquery.model.S3ReportLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3ReportLocation())
        .map(value =>
          zio.aws.timestreamquery.model.S3ReportLocation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.ErrorReportLocation
  ): zio.aws.timestreamquery.model.ErrorReportLocation.ReadOnly = new Wrapper(
    impl
  )
}
