package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.ResourceName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TimestreamDestination(
    databaseName: Optional[ResourceName] = Optional.Absent,
    tableName: Optional[ResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.TimestreamDestination = {
    import TimestreamDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.TimestreamDestination
      .builder()
      .optionallyWith(
        databaseName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.databaseName)
      .optionallyWith(
        tableName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.tableName)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.TimestreamDestination.ReadOnly =
    zio.aws.timestreamquery.model.TimestreamDestination.wrap(buildAwsValue())
}
object TimestreamDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.TimestreamDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.TimestreamDestination =
      zio.aws.timestreamquery.model.TimestreamDestination(
        databaseName.map(value => value),
        tableName.map(value => value)
      )
    def databaseName: Optional[ResourceName]
    def tableName: Optional[ResourceName]
    def getDatabaseName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getTableName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("tableName", tableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.TimestreamDestination
  ) extends zio.aws.timestreamquery.model.TimestreamDestination.ReadOnly {
    override val databaseName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value =>
        zio.aws.timestreamquery.model.primitives.ResourceName(value)
      )
    override val tableName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value =>
        zio.aws.timestreamquery.model.primitives.ResourceName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.TimestreamDestination
  ): zio.aws.timestreamquery.model.TimestreamDestination.ReadOnly = new Wrapper(
    impl
  )
}
