package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExecutionStats(
    executionTimeInMillis: Optional[Long] = Optional.Absent,
    dataWrites: Optional[Long] = Optional.Absent,
    bytesMetered: Optional[Long] = Optional.Absent,
    recordsIngested: Optional[Long] = Optional.Absent,
    queryResultRows: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.ExecutionStats = {
    import ExecutionStats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.ExecutionStats
      .builder()
      .optionallyWith(
        executionTimeInMillis.map(value => value: java.lang.Long)
      )(_.executionTimeInMillis)
      .optionallyWith(dataWrites.map(value => value: java.lang.Long))(
        _.dataWrites
      )
      .optionallyWith(bytesMetered.map(value => value: java.lang.Long))(
        _.bytesMetered
      )
      .optionallyWith(recordsIngested.map(value => value: java.lang.Long))(
        _.recordsIngested
      )
      .optionallyWith(queryResultRows.map(value => value: java.lang.Long))(
        _.queryResultRows
      )
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.ExecutionStats.ReadOnly =
    zio.aws.timestreamquery.model.ExecutionStats.wrap(buildAwsValue())
}
object ExecutionStats {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.ExecutionStats
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.ExecutionStats =
      zio.aws.timestreamquery.model.ExecutionStats(
        executionTimeInMillis.map(value => value),
        dataWrites.map(value => value),
        bytesMetered.map(value => value),
        recordsIngested.map(value => value),
        queryResultRows.map(value => value)
      )
    def executionTimeInMillis: Optional[Long]
    def dataWrites: Optional[Long]
    def bytesMetered: Optional[Long]
    def recordsIngested: Optional[Long]
    def queryResultRows: Optional[Long]
    def getExecutionTimeInMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("executionTimeInMillis", executionTimeInMillis)
    def getDataWrites: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("dataWrites", dataWrites)
    def getBytesMetered: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("bytesMetered", bytesMetered)
    def getRecordsIngested: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("recordsIngested", recordsIngested)
    def getQueryResultRows: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("queryResultRows", queryResultRows)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.ExecutionStats
  ) extends zio.aws.timestreamquery.model.ExecutionStats.ReadOnly {
    override val executionTimeInMillis: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.executionTimeInMillis())
      .map(value => value: Long)
    override val dataWrites: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.dataWrites())
      .map(value => value: Long)
    override val bytesMetered: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.bytesMetered())
      .map(value => value: Long)
    override val recordsIngested: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.recordsIngested())
      .map(value => value: Long)
    override val queryResultRows: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.queryResultRows())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.ExecutionStats
  ): zio.aws.timestreamquery.model.ExecutionStats.ReadOnly = new Wrapper(impl)
}
