package zio.aws.timestreamquery.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.timestreamquery.model.primitives.{
  NextScheduledQueriesResultsToken,
  MaxScheduledQueriesResults
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListScheduledQueriesRequest(
    maxResults: Optional[MaxScheduledQueriesResults] = Optional.Absent,
    nextToken: Optional[NextScheduledQueriesResultsToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesRequest = {
    import ListScheduledQueriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          MaxScheduledQueriesResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          NextScheduledQueriesResultsToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.ListScheduledQueriesRequest.ReadOnly =
    zio.aws.timestreamquery.model.ListScheduledQueriesRequest
      .wrap(buildAwsValue())
}
object ListScheduledQueriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.ListScheduledQueriesRequest =
      zio.aws.timestreamquery.model.ListScheduledQueriesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxScheduledQueriesResults]
    def nextToken: Optional[NextScheduledQueriesResultsToken]
    def getMaxResults: ZIO[Any, AwsError, MaxScheduledQueriesResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextScheduledQueriesResultsToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesRequest
  ) extends zio.aws.timestreamquery.model.ListScheduledQueriesRequest.ReadOnly {
    override val maxResults: Optional[MaxScheduledQueriesResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.timestreamquery.model.primitives
            .MaxScheduledQueriesResults(value)
        )
    override val nextToken: Optional[NextScheduledQueriesResultsToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.timestreamquery.model.primitives
            .NextScheduledQueriesResultsToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesRequest
  ): zio.aws.timestreamquery.model.ListScheduledQueriesRequest.ReadOnly =
    new Wrapper(impl)
}
