package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeScheduledQueryResponse(
    scheduledQuery: zio.aws.timestreamquery.model.ScheduledQueryDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryResponse = {
    import DescribeScheduledQueryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryResponse
      .builder()
      .scheduledQuery(scheduledQuery.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.DescribeScheduledQueryResponse.ReadOnly =
    zio.aws.timestreamquery.model.DescribeScheduledQueryResponse
      .wrap(buildAwsValue())
}
object DescribeScheduledQueryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.timestreamquery.model.DescribeScheduledQueryResponse =
      zio.aws.timestreamquery.model
        .DescribeScheduledQueryResponse(scheduledQuery.asEditable)
    def scheduledQuery
        : zio.aws.timestreamquery.model.ScheduledQueryDescription.ReadOnly
    def getScheduledQuery: ZIO[
      Any,
      Nothing,
      zio.aws.timestreamquery.model.ScheduledQueryDescription.ReadOnly
    ] = ZIO.succeed(scheduledQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryResponse
  ) extends zio.aws.timestreamquery.model.DescribeScheduledQueryResponse.ReadOnly {
    override val scheduledQuery
        : zio.aws.timestreamquery.model.ScheduledQueryDescription.ReadOnly =
      zio.aws.timestreamquery.model.ScheduledQueryDescription
        .wrap(impl.scheduledQuery())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryResponse
  ): zio.aws.timestreamquery.model.DescribeScheduledQueryResponse.ReadOnly =
    new Wrapper(impl)
}
