package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.AmazonResourceName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteScheduledQueryRequest(
    scheduledQueryArn: AmazonResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.DeleteScheduledQueryRequest = {
    import DeleteScheduledQueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.DeleteScheduledQueryRequest
      .builder()
      .scheduledQueryArn(
        AmazonResourceName.unwrap(scheduledQueryArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.DeleteScheduledQueryRequest.ReadOnly =
    zio.aws.timestreamquery.model.DeleteScheduledQueryRequest
      .wrap(buildAwsValue())
}
object DeleteScheduledQueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.DeleteScheduledQueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.DeleteScheduledQueryRequest =
      zio.aws.timestreamquery.model
        .DeleteScheduledQueryRequest(scheduledQueryArn)
    def scheduledQueryArn: AmazonResourceName
    def getScheduledQueryArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(scheduledQueryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.DeleteScheduledQueryRequest
  ) extends zio.aws.timestreamquery.model.DeleteScheduledQueryRequest.ReadOnly {
    override val scheduledQueryArn: AmazonResourceName =
      zio.aws.timestreamquery.model.primitives
        .AmazonResourceName(impl.scheduledQueryArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.DeleteScheduledQueryRequest
  ): zio.aws.timestreamquery.model.DeleteScheduledQueryRequest.ReadOnly =
    new Wrapper(impl)
}
