package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class QueryStatus(
    progressPercentage: Optional[Double] = Optional.Absent,
    cumulativeBytesScanned: Optional[Long] = Optional.Absent,
    cumulativeBytesMetered: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.QueryStatus = {
    import QueryStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.QueryStatus
      .builder()
      .optionallyWith(progressPercentage.map(value => value: java.lang.Double))(
        _.progressPercentage
      )
      .optionallyWith(
        cumulativeBytesScanned.map(value => value: java.lang.Long)
      )(_.cumulativeBytesScanned)
      .optionallyWith(
        cumulativeBytesMetered.map(value => value: java.lang.Long)
      )(_.cumulativeBytesMetered)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.QueryStatus.ReadOnly =
    zio.aws.timestreamquery.model.QueryStatus.wrap(buildAwsValue())
}
object QueryStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.QueryStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.QueryStatus =
      zio.aws.timestreamquery.model.QueryStatus(
        progressPercentage.map(value => value),
        cumulativeBytesScanned.map(value => value),
        cumulativeBytesMetered.map(value => value)
      )
    def progressPercentage: Optional[Double]
    def cumulativeBytesScanned: Optional[Long]
    def cumulativeBytesMetered: Optional[Long]
    def getProgressPercentage: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("progressPercentage", progressPercentage)
    def getCumulativeBytesScanned: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("cumulativeBytesScanned", cumulativeBytesScanned)
    def getCumulativeBytesMetered: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("cumulativeBytesMetered", cumulativeBytesMetered)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.QueryStatus
  ) extends zio.aws.timestreamquery.model.QueryStatus.ReadOnly {
    override val progressPercentage: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.progressPercentage())
      .map(value => value: Double)
    override val cumulativeBytesScanned: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.cumulativeBytesScanned())
      .map(value => value: Long)
    override val cumulativeBytesMetered: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.cumulativeBytesMetered())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.QueryStatus
  ): zio.aws.timestreamquery.model.QueryStatus.ReadOnly = new Wrapper(impl)
}
