package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class NotificationConfiguration(
    snsConfiguration: zio.aws.timestreamquery.model.SnsConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.NotificationConfiguration = {
    import NotificationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.NotificationConfiguration
      .builder()
      .snsConfiguration(snsConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.NotificationConfiguration.ReadOnly =
    zio.aws.timestreamquery.model.NotificationConfiguration
      .wrap(buildAwsValue())
}
object NotificationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.NotificationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.NotificationConfiguration =
      zio.aws.timestreamquery.model
        .NotificationConfiguration(snsConfiguration.asEditable)
    def snsConfiguration
        : zio.aws.timestreamquery.model.SnsConfiguration.ReadOnly
    def getSnsConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.timestreamquery.model.SnsConfiguration.ReadOnly
    ] = ZIO.succeed(snsConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.NotificationConfiguration
  ) extends zio.aws.timestreamquery.model.NotificationConfiguration.ReadOnly {
    override val snsConfiguration
        : zio.aws.timestreamquery.model.SnsConfiguration.ReadOnly =
      zio.aws.timestreamquery.model.SnsConfiguration
        .wrap(impl.snsConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.NotificationConfiguration
  ): zio.aws.timestreamquery.model.NotificationConfiguration.ReadOnly =
    new Wrapper(impl)
}
