package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.{SchemaName, ResourceName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TimestreamConfiguration(
    databaseName: ResourceName,
    tableName: ResourceName,
    timeColumn: SchemaName,
    dimensionMappings: Iterable[zio.aws.timestreamquery.model.DimensionMapping],
    multiMeasureMappings: Option[
      zio.aws.timestreamquery.model.MultiMeasureMappings
    ] = None,
    mixedMeasureMappings: Option[
      Iterable[zio.aws.timestreamquery.model.MixedMeasureMapping]
    ] = None,
    measureNameColumn: Option[SchemaName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.TimestreamConfiguration = {
    import TimestreamConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.TimestreamConfiguration
      .builder()
      .databaseName(ResourceName.unwrap(databaseName): java.lang.String)
      .tableName(ResourceName.unwrap(tableName): java.lang.String)
      .timeColumn(SchemaName.unwrap(timeColumn): java.lang.String)
      .dimensionMappings(dimensionMappings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(multiMeasureMappings.map(value => value.buildAwsValue()))(
        _.multiMeasureMappings
      )
      .optionallyWith(
        mixedMeasureMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mixedMeasureMappings)
      .optionallyWith(
        measureNameColumn.map(value =>
          SchemaName.unwrap(value): java.lang.String
        )
      )(_.measureNameColumn)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.TimestreamConfiguration.ReadOnly =
    zio.aws.timestreamquery.model.TimestreamConfiguration.wrap(buildAwsValue())
}
object TimestreamConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.TimestreamConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.TimestreamConfiguration =
      zio.aws.timestreamquery.model.TimestreamConfiguration(
        databaseName,
        tableName,
        timeColumn,
        dimensionMappings.map { item =>
          item.asEditable
        },
        multiMeasureMappings.map(value => value.asEditable),
        mixedMeasureMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        measureNameColumn.map(value => value)
      )
    def databaseName: ResourceName
    def tableName: ResourceName
    def timeColumn: SchemaName
    def dimensionMappings
        : List[zio.aws.timestreamquery.model.DimensionMapping.ReadOnly]
    def multiMeasureMappings
        : Option[zio.aws.timestreamquery.model.MultiMeasureMappings.ReadOnly]
    def mixedMeasureMappings: Option[
      List[zio.aws.timestreamquery.model.MixedMeasureMapping.ReadOnly]
    ]
    def measureNameColumn: Option[SchemaName]
    def getDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(tableName)
    def getTimeColumn: ZIO[Any, Nothing, SchemaName] = ZIO.succeed(timeColumn)
    def getDimensionMappings: ZIO[Any, Nothing, List[
      zio.aws.timestreamquery.model.DimensionMapping.ReadOnly
    ]] = ZIO.succeed(dimensionMappings)
    def getMultiMeasureMappings: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.MultiMeasureMappings.ReadOnly
    ] = AwsError.unwrapOptionField("multiMeasureMappings", multiMeasureMappings)
    def getMixedMeasureMappings: ZIO[Any, AwsError, List[
      zio.aws.timestreamquery.model.MixedMeasureMapping.ReadOnly
    ]] =
      AwsError.unwrapOptionField("mixedMeasureMappings", mixedMeasureMappings)
    def getMeasureNameColumn: ZIO[Any, AwsError, SchemaName] =
      AwsError.unwrapOptionField("measureNameColumn", measureNameColumn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.TimestreamConfiguration
  ) extends zio.aws.timestreamquery.model.TimestreamConfiguration.ReadOnly {
    override val databaseName: ResourceName =
      zio.aws.timestreamquery.model.primitives.ResourceName(impl.databaseName())
    override val tableName: ResourceName =
      zio.aws.timestreamquery.model.primitives.ResourceName(impl.tableName())
    override val timeColumn: SchemaName =
      zio.aws.timestreamquery.model.primitives.SchemaName(impl.timeColumn())
    override val dimensionMappings
        : List[zio.aws.timestreamquery.model.DimensionMapping.ReadOnly] = impl
      .dimensionMappings()
      .asScala
      .map { item =>
        zio.aws.timestreamquery.model.DimensionMapping.wrap(item)
      }
      .toList
    override val multiMeasureMappings
        : Option[zio.aws.timestreamquery.model.MultiMeasureMappings.ReadOnly] =
      scala
        .Option(impl.multiMeasureMappings())
        .map(value =>
          zio.aws.timestreamquery.model.MultiMeasureMappings.wrap(value)
        )
    override val mixedMeasureMappings: Option[
      List[zio.aws.timestreamquery.model.MixedMeasureMapping.ReadOnly]
    ] = scala
      .Option(impl.mixedMeasureMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.timestreamquery.model.MixedMeasureMapping.wrap(item)
        }.toList
      )
    override val measureNameColumn: Option[SchemaName] = scala
      .Option(impl.measureNameColumn())
      .map(value => zio.aws.timestreamquery.model.primitives.SchemaName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.TimestreamConfiguration
  ): zio.aws.timestreamquery.model.TimestreamConfiguration.ReadOnly =
    new Wrapper(impl)
}
