package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.{ErrorMessage, Time}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ScheduledQueryRunSummary(
    invocationTime: Option[Time] = None,
    triggerTime: Option[Time] = None,
    runStatus: Option[zio.aws.timestreamquery.model.ScheduledQueryRunStatus] =
      None,
    executionStats: Option[zio.aws.timestreamquery.model.ExecutionStats] = None,
    errorReportLocation: Option[
      zio.aws.timestreamquery.model.ErrorReportLocation
    ] = None,
    failureReason: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryRunSummary = {
    import ScheduledQueryRunSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryRunSummary
      .builder()
      .optionallyWith(invocationTime.map(value => Time.unwrap(value): Instant))(
        _.invocationTime
      )
      .optionallyWith(triggerTime.map(value => Time.unwrap(value): Instant))(
        _.triggerTime
      )
      .optionallyWith(runStatus.map(value => value.unwrap))(_.runStatus)
      .optionallyWith(executionStats.map(value => value.buildAwsValue()))(
        _.executionStats
      )
      .optionallyWith(errorReportLocation.map(value => value.buildAwsValue()))(
        _.errorReportLocation
      )
      .optionallyWith(
        failureReason.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.failureReason)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.ScheduledQueryRunSummary.ReadOnly =
    zio.aws.timestreamquery.model.ScheduledQueryRunSummary.wrap(buildAwsValue())
}
object ScheduledQueryRunSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryRunSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.ScheduledQueryRunSummary =
      zio.aws.timestreamquery.model.ScheduledQueryRunSummary(
        invocationTime.map(value => value),
        triggerTime.map(value => value),
        runStatus.map(value => value),
        executionStats.map(value => value.asEditable),
        errorReportLocation.map(value => value.asEditable),
        failureReason.map(value => value)
      )
    def invocationTime: Option[Time]
    def triggerTime: Option[Time]
    def runStatus: Option[zio.aws.timestreamquery.model.ScheduledQueryRunStatus]
    def executionStats
        : Option[zio.aws.timestreamquery.model.ExecutionStats.ReadOnly]
    def errorReportLocation
        : Option[zio.aws.timestreamquery.model.ErrorReportLocation.ReadOnly]
    def failureReason: Option[ErrorMessage]
    def getInvocationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("invocationTime", invocationTime)
    def getTriggerTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("triggerTime", triggerTime)
    def getRunStatus: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.ScheduledQueryRunStatus
    ] = AwsError.unwrapOptionField("runStatus", runStatus)
    def getExecutionStats: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.ExecutionStats.ReadOnly
    ] = AwsError.unwrapOptionField("executionStats", executionStats)
    def getErrorReportLocation: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.ErrorReportLocation.ReadOnly
    ] = AwsError.unwrapOptionField("errorReportLocation", errorReportLocation)
    def getFailureReason: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryRunSummary
  ) extends zio.aws.timestreamquery.model.ScheduledQueryRunSummary.ReadOnly {
    override val invocationTime: Option[Time] = scala
      .Option(impl.invocationTime())
      .map(value => zio.aws.timestreamquery.model.primitives.Time(value))
    override val triggerTime: Option[Time] = scala
      .Option(impl.triggerTime())
      .map(value => zio.aws.timestreamquery.model.primitives.Time(value))
    override val runStatus
        : Option[zio.aws.timestreamquery.model.ScheduledQueryRunStatus] = scala
      .Option(impl.runStatus())
      .map(value =>
        zio.aws.timestreamquery.model.ScheduledQueryRunStatus.wrap(value)
      )
    override val executionStats
        : Option[zio.aws.timestreamquery.model.ExecutionStats.ReadOnly] = scala
      .Option(impl.executionStats())
      .map(value => zio.aws.timestreamquery.model.ExecutionStats.wrap(value))
    override val errorReportLocation
        : Option[zio.aws.timestreamquery.model.ErrorReportLocation.ReadOnly] =
      scala
        .Option(impl.errorReportLocation())
        .map(value =>
          zio.aws.timestreamquery.model.ErrorReportLocation.wrap(value)
        )
    override val failureReason: Option[ErrorMessage] = scala
      .Option(impl.failureReason())
      .map(value =>
        zio.aws.timestreamquery.model.primitives.ErrorMessage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryRunSummary
  ): zio.aws.timestreamquery.model.ScheduledQueryRunSummary.ReadOnly =
    new Wrapper(impl)
}
