package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TargetConfiguration(
    timestreamConfiguration: zio.aws.timestreamquery.model.TimestreamConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.TargetConfiguration = {
    import TargetConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.TargetConfiguration
      .builder()
      .timestreamConfiguration(timestreamConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.TargetConfiguration.ReadOnly =
    zio.aws.timestreamquery.model.TargetConfiguration.wrap(buildAwsValue())
}
object TargetConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.TargetConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.TargetConfiguration =
      zio.aws.timestreamquery.model
        .TargetConfiguration(timestreamConfiguration.asEditable)
    def timestreamConfiguration
        : zio.aws.timestreamquery.model.TimestreamConfiguration.ReadOnly
    def getTimestreamConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.timestreamquery.model.TimestreamConfiguration.ReadOnly
    ] = ZIO.succeed(timestreamConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.TargetConfiguration
  ) extends zio.aws.timestreamquery.model.TargetConfiguration.ReadOnly {
    override val timestreamConfiguration
        : zio.aws.timestreamquery.model.TimestreamConfiguration.ReadOnly =
      zio.aws.timestreamquery.model.TimestreamConfiguration
        .wrap(impl.timestreamConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.TargetConfiguration
  ): zio.aws.timestreamquery.model.TargetConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
