package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.ScheduleExpression
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ScheduleConfiguration(scheduleExpression: ScheduleExpression) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.ScheduleConfiguration = {
    import ScheduleConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.ScheduleConfiguration
      .builder()
      .scheduleExpression(
        ScheduleExpression.unwrap(scheduleExpression): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.ScheduleConfiguration.ReadOnly =
    zio.aws.timestreamquery.model.ScheduleConfiguration.wrap(buildAwsValue())
}
object ScheduleConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.ScheduleConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.ScheduleConfiguration =
      zio.aws.timestreamquery.model.ScheduleConfiguration(scheduleExpression)
    def scheduleExpression: ScheduleExpression
    def getScheduleExpression: ZIO[Any, Nothing, ScheduleExpression] =
      ZIO.succeed(scheduleExpression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.ScheduleConfiguration
  ) extends zio.aws.timestreamquery.model.ScheduleConfiguration.ReadOnly {
    override val scheduleExpression: ScheduleExpression =
      zio.aws.timestreamquery.model.primitives
        .ScheduleExpression(impl.scheduleExpression())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.ScheduleConfiguration
  ): zio.aws.timestreamquery.model.ScheduleConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
