package zio.aws.timestreamquery.model
import scala.jdk.CollectionConverters.*
sealed trait ScalarType {
  def unwrap: software.amazon.awssdk.services.timestreamquery.model.ScalarType
}
object ScalarType {
  def wrap(
      value: software.amazon.awssdk.services.timestreamquery.model.ScalarType
  ): zio.aws.timestreamquery.model.ScalarType = value match {
    case software.amazon.awssdk.services.timestreamquery.model.ScalarType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.timestreamquery.model.ScalarType.VARCHAR =>
      val r = VARCHAR
      r
    case software.amazon.awssdk.services.timestreamquery.model.ScalarType.BOOLEAN =>
      val r = BOOLEAN
      r
    case software.amazon.awssdk.services.timestreamquery.model.ScalarType.BIGINT =>
      val r = BIGINT
      r
    case software.amazon.awssdk.services.timestreamquery.model.ScalarType.DOUBLE =>
      val r = DOUBLE
      r
    case software.amazon.awssdk.services.timestreamquery.model.ScalarType.TIMESTAMP =>
      val r = TIMESTAMP
      r
    case software.amazon.awssdk.services.timestreamquery.model.ScalarType.DATE =>
      val r = DATE
      r
    case software.amazon.awssdk.services.timestreamquery.model.ScalarType.TIME =>
      val r = TIME
      r
    case software.amazon.awssdk.services.timestreamquery.model.ScalarType.INTERVAL_DAY_TO_SECOND =>
      val r = INTERVAL_DAY_TO_SECOND
      r
    case software.amazon.awssdk.services.timestreamquery.model.ScalarType.INTERVAL_YEAR_TO_MONTH =>
      val r = INTERVAL_YEAR_TO_MONTH
      r
    case software.amazon.awssdk.services.timestreamquery.model.ScalarType.UNKNOWN =>
      val r = UNKNOWN
      r
    case software.amazon.awssdk.services.timestreamquery.model.ScalarType.INTEGER =>
      val r = INTEGER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.timestreamquery.model.ScalarType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.ScalarType =
      software.amazon.awssdk.services.timestreamquery.model.ScalarType.UNKNOWN_TO_SDK_VERSION
  }
  case object VARCHAR extends zio.aws.timestreamquery.model.ScalarType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.ScalarType =
      software.amazon.awssdk.services.timestreamquery.model.ScalarType.VARCHAR
  }
  case object BOOLEAN extends zio.aws.timestreamquery.model.ScalarType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.ScalarType =
      software.amazon.awssdk.services.timestreamquery.model.ScalarType.BOOLEAN
  }
  case object BIGINT extends zio.aws.timestreamquery.model.ScalarType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.ScalarType =
      software.amazon.awssdk.services.timestreamquery.model.ScalarType.BIGINT
  }
  case object DOUBLE extends zio.aws.timestreamquery.model.ScalarType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.ScalarType =
      software.amazon.awssdk.services.timestreamquery.model.ScalarType.DOUBLE
  }
  case object TIMESTAMP extends zio.aws.timestreamquery.model.ScalarType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.ScalarType =
      software.amazon.awssdk.services.timestreamquery.model.ScalarType.TIMESTAMP
  }
  case object DATE extends zio.aws.timestreamquery.model.ScalarType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.ScalarType =
      software.amazon.awssdk.services.timestreamquery.model.ScalarType.DATE
  }
  case object TIME extends zio.aws.timestreamquery.model.ScalarType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.ScalarType =
      software.amazon.awssdk.services.timestreamquery.model.ScalarType.TIME
  }
  case object INTERVAL_DAY_TO_SECOND
      extends zio.aws.timestreamquery.model.ScalarType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.ScalarType =
      software.amazon.awssdk.services.timestreamquery.model.ScalarType.INTERVAL_DAY_TO_SECOND
  }
  case object INTERVAL_YEAR_TO_MONTH
      extends zio.aws.timestreamquery.model.ScalarType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.ScalarType =
      software.amazon.awssdk.services.timestreamquery.model.ScalarType.INTERVAL_YEAR_TO_MONTH
  }
  case object UNKNOWN extends zio.aws.timestreamquery.model.ScalarType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.ScalarType =
      software.amazon.awssdk.services.timestreamquery.model.ScalarType.UNKNOWN
  }
  case object INTEGER extends zio.aws.timestreamquery.model.ScalarType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.ScalarType =
      software.amazon.awssdk.services.timestreamquery.model.ScalarType.INTEGER
  }
}
