package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.AmazonResourceName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SnsConfiguration(topicArn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.SnsConfiguration = {
    import SnsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.SnsConfiguration
      .builder()
      .topicArn(AmazonResourceName.unwrap(topicArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.SnsConfiguration.ReadOnly =
    zio.aws.timestreamquery.model.SnsConfiguration.wrap(buildAwsValue())
}
object SnsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.SnsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.SnsConfiguration =
      zio.aws.timestreamquery.model.SnsConfiguration(topicArn)
    def topicArn: AmazonResourceName
    def getTopicArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(topicArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.SnsConfiguration
  ) extends zio.aws.timestreamquery.model.SnsConfiguration.ReadOnly {
    override val topicArn: AmazonResourceName =
      zio.aws.timestreamquery.model.primitives
        .AmazonResourceName(impl.topicArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.SnsConfiguration
  ): zio.aws.timestreamquery.model.SnsConfiguration.ReadOnly = new Wrapper(impl)
}
