package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.{NullableBoolean, ScalarValue}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Datum(
    scalarValue: Option[ScalarValue] = None,
    timeSeriesValue: Option[
      Iterable[zio.aws.timestreamquery.model.TimeSeriesDataPoint]
    ] = None,
    arrayValue: Option[Iterable[zio.aws.timestreamquery.model.Datum]] = None,
    rowValue: Option[zio.aws.timestreamquery.model.Row] = None,
    nullValue: Option[NullableBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.Datum = {
    import Datum.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.Datum
      .builder()
      .optionallyWith(
        scalarValue.map(value => ScalarValue.unwrap(value): java.lang.String)
      )(_.scalarValue)
      .optionallyWith(
        timeSeriesValue.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.timeSeriesValue)
      .optionallyWith(
        arrayValue.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.arrayValue)
      .optionallyWith(rowValue.map(value => value.buildAwsValue()))(_.rowValue)
      .optionallyWith(
        nullValue.map(value => NullableBoolean.unwrap(value): java.lang.Boolean)
      )(_.nullValue)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.Datum.ReadOnly =
    zio.aws.timestreamquery.model.Datum.wrap(buildAwsValue())
}
object Datum {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.Datum
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.Datum =
      zio.aws.timestreamquery.model.Datum(
        scalarValue.map(value => value),
        timeSeriesValue.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        arrayValue.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        rowValue.map(value => value.asEditable),
        nullValue.map(value => value)
      )
    def scalarValue: Option[ScalarValue]
    def timeSeriesValue: Option[
      List[zio.aws.timestreamquery.model.TimeSeriesDataPoint.ReadOnly]
    ]
    def arrayValue: Option[List[zio.aws.timestreamquery.model.Datum.ReadOnly]]
    def rowValue: Option[zio.aws.timestreamquery.model.Row.ReadOnly]
    def nullValue: Option[NullableBoolean]
    def getScalarValue: ZIO[Any, AwsError, ScalarValue] =
      AwsError.unwrapOptionField("scalarValue", scalarValue)
    def getTimeSeriesValue: ZIO[Any, AwsError, List[
      zio.aws.timestreamquery.model.TimeSeriesDataPoint.ReadOnly
    ]] = AwsError.unwrapOptionField("timeSeriesValue", timeSeriesValue)
    def getArrayValue: ZIO[Any, AwsError, List[
      zio.aws.timestreamquery.model.Datum.ReadOnly
    ]] = AwsError.unwrapOptionField("arrayValue", arrayValue)
    def getRowValue
        : ZIO[Any, AwsError, zio.aws.timestreamquery.model.Row.ReadOnly] =
      AwsError.unwrapOptionField("rowValue", rowValue)
    def getNullValue: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("nullValue", nullValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.Datum
  ) extends zio.aws.timestreamquery.model.Datum.ReadOnly {
    override val scalarValue: Option[ScalarValue] = scala
      .Option(impl.scalarValue())
      .map(value => zio.aws.timestreamquery.model.primitives.ScalarValue(value))
    override val timeSeriesValue: Option[
      List[zio.aws.timestreamquery.model.TimeSeriesDataPoint.ReadOnly]
    ] = scala
      .Option(impl.timeSeriesValue())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.timestreamquery.model.TimeSeriesDataPoint.wrap(item)
        }.toList
      )
    override val arrayValue
        : Option[List[zio.aws.timestreamquery.model.Datum.ReadOnly]] = scala
      .Option(impl.arrayValue())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.timestreamquery.model.Datum.wrap(item)
        }.toList
      )
    override val rowValue: Option[zio.aws.timestreamquery.model.Row.ReadOnly] =
      scala
        .Option(impl.rowValue())
        .map(value => zio.aws.timestreamquery.model.Row.wrap(value))
    override val nullValue: Option[NullableBoolean] = scala
      .Option(impl.nullValue())
      .map(value =>
        zio.aws.timestreamquery.model.primitives.NullableBoolean(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.Datum
  ): zio.aws.timestreamquery.model.Datum.ReadOnly = new Wrapper(impl)
}
