package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Type(
    scalarType: Option[zio.aws.timestreamquery.model.ScalarType] = None,
    arrayColumnInfo: Option[zio.aws.timestreamquery.model.ColumnInfo] = None,
    timeSeriesMeasureValueColumnInfo: Option[
      zio.aws.timestreamquery.model.ColumnInfo
    ] = None,
    rowColumnInfo: Option[Iterable[zio.aws.timestreamquery.model.ColumnInfo]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.Type = {
    import Type.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.Type
      .builder()
      .optionallyWith(scalarType.map(value => value.unwrap))(_.scalarType)
      .optionallyWith(arrayColumnInfo.map(value => value.buildAwsValue()))(
        _.arrayColumnInfo
      )
      .optionallyWith(
        timeSeriesMeasureValueColumnInfo.map(value => value.buildAwsValue())
      )(_.timeSeriesMeasureValueColumnInfo)
      .optionallyWith(
        rowColumnInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rowColumnInfo)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.Type.ReadOnly =
    zio.aws.timestreamquery.model.Type.wrap(buildAwsValue())
}
object Type {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.Type
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.Type =
      zio.aws.timestreamquery.model.Type(
        scalarType.map(value => value),
        arrayColumnInfo.map(value => value.asEditable),
        timeSeriesMeasureValueColumnInfo.map(value => value.asEditable),
        rowColumnInfo.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def scalarType: Option[zio.aws.timestreamquery.model.ScalarType]
    def arrayColumnInfo
        : Option[zio.aws.timestreamquery.model.ColumnInfo.ReadOnly]
    def timeSeriesMeasureValueColumnInfo
        : Option[zio.aws.timestreamquery.model.ColumnInfo.ReadOnly]
    def rowColumnInfo
        : Option[List[zio.aws.timestreamquery.model.ColumnInfo.ReadOnly]]
    def getScalarType
        : ZIO[Any, AwsError, zio.aws.timestreamquery.model.ScalarType] =
      AwsError.unwrapOptionField("scalarType", scalarType)
    def getArrayColumnInfo: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.ColumnInfo.ReadOnly
    ] = AwsError.unwrapOptionField("arrayColumnInfo", arrayColumnInfo)
    def getTimeSeriesMeasureValueColumnInfo: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.ColumnInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "timeSeriesMeasureValueColumnInfo",
      timeSeriesMeasureValueColumnInfo
    )
    def getRowColumnInfo: ZIO[Any, AwsError, List[
      zio.aws.timestreamquery.model.ColumnInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("rowColumnInfo", rowColumnInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.Type
  ) extends zio.aws.timestreamquery.model.Type.ReadOnly {
    override val scalarType: Option[zio.aws.timestreamquery.model.ScalarType] =
      scala
        .Option(impl.scalarType())
        .map(value => zio.aws.timestreamquery.model.ScalarType.wrap(value))
    override val arrayColumnInfo
        : Option[zio.aws.timestreamquery.model.ColumnInfo.ReadOnly] = scala
      .Option(impl.arrayColumnInfo())
      .map(value => zio.aws.timestreamquery.model.ColumnInfo.wrap(value))
    override val timeSeriesMeasureValueColumnInfo
        : Option[zio.aws.timestreamquery.model.ColumnInfo.ReadOnly] = scala
      .Option(impl.timeSeriesMeasureValueColumnInfo())
      .map(value => zio.aws.timestreamquery.model.ColumnInfo.wrap(value))
    override val rowColumnInfo
        : Option[List[zio.aws.timestreamquery.model.ColumnInfo.ReadOnly]] =
      scala
        .Option(impl.rowColumnInfo())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.timestreamquery.model.ColumnInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.Type
  ): zio.aws.timestreamquery.model.Type.ReadOnly = new Wrapper(impl)
}
