package zio.aws.timestreamquery.model
import java.lang.Integer
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.{
  MaxQueryResults,
  PaginationToken,
  ClientRequestToken,
  QueryString
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class QueryRequest(
    queryString: QueryString,
    clientToken: Option[ClientRequestToken] = None,
    nextToken: Option[PaginationToken] = None,
    maxRows: Option[MaxQueryResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.QueryRequest = {
    import QueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.QueryRequest
      .builder()
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .optionallyWith(
        clientToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxRows.map(value => MaxQueryResults.unwrap(value): Integer)
      )(_.maxRows)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.QueryRequest.ReadOnly =
    zio.aws.timestreamquery.model.QueryRequest.wrap(buildAwsValue())
}
object QueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.QueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.QueryRequest =
      zio.aws.timestreamquery.model.QueryRequest(
        queryString,
        clientToken.map(value => value),
        nextToken.map(value => value),
        maxRows.map(value => value)
      )
    def queryString: QueryString
    def clientToken: Option[ClientRequestToken]
    def nextToken: Option[PaginationToken]
    def maxRows: Option[MaxQueryResults]
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getClientToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxRows: ZIO[Any, AwsError, MaxQueryResults] =
      AwsError.unwrapOptionField("maxRows", maxRows)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.QueryRequest
  ) extends zio.aws.timestreamquery.model.QueryRequest.ReadOnly {
    override val queryString: QueryString =
      zio.aws.timestreamquery.model.primitives.QueryString(impl.queryString())
    override val clientToken: Option[ClientRequestToken] = scala
      .Option(impl.clientToken())
      .map(value =>
        zio.aws.timestreamquery.model.primitives.ClientRequestToken(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.timestreamquery.model.primitives.PaginationToken(value)
      )
    override val maxRows: Option[MaxQueryResults] = scala
      .Option(impl.maxRows())
      .map(value =>
        zio.aws.timestreamquery.model.primitives.MaxQueryResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.QueryRequest
  ): zio.aws.timestreamquery.model.QueryRequest.ReadOnly = new Wrapper(impl)
}
