package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.{
  Time,
  StringValue2048,
  ScheduledQueryName,
  AmazonResourceName,
  QueryString
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ScheduledQueryDescription(
    arn: AmazonResourceName,
    name: ScheduledQueryName,
    queryString: QueryString,
    creationTime: Option[Time] = None,
    state: zio.aws.timestreamquery.model.ScheduledQueryState,
    previousInvocationTime: Option[Time] = None,
    nextInvocationTime: Option[Time] = None,
    scheduleConfiguration: zio.aws.timestreamquery.model.ScheduleConfiguration,
    notificationConfiguration: zio.aws.timestreamquery.model.NotificationConfiguration,
    targetConfiguration: Option[
      zio.aws.timestreamquery.model.TargetConfiguration
    ] = None,
    scheduledQueryExecutionRoleArn: Option[AmazonResourceName] = None,
    kmsKeyId: Option[StringValue2048] = None,
    errorReportConfiguration: Option[
      zio.aws.timestreamquery.model.ErrorReportConfiguration
    ] = None,
    lastRunSummary: Option[
      zio.aws.timestreamquery.model.ScheduledQueryRunSummary
    ] = None,
    recentlyFailedRuns: Option[
      Iterable[zio.aws.timestreamquery.model.ScheduledQueryRunSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryDescription = {
    import ScheduledQueryDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryDescription
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .name(ScheduledQueryName.unwrap(name): java.lang.String)
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .state(state.unwrap)
      .optionallyWith(
        previousInvocationTime.map(value => Time.unwrap(value): Instant)
      )(_.previousInvocationTime)
      .optionallyWith(
        nextInvocationTime.map(value => Time.unwrap(value): Instant)
      )(_.nextInvocationTime)
      .scheduleConfiguration(scheduleConfiguration.buildAwsValue())
      .notificationConfiguration(notificationConfiguration.buildAwsValue())
      .optionallyWith(targetConfiguration.map(value => value.buildAwsValue()))(
        _.targetConfiguration
      )
      .optionallyWith(
        scheduledQueryExecutionRoleArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.scheduledQueryExecutionRoleArn)
      .optionallyWith(
        kmsKeyId.map(value => StringValue2048.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        errorReportConfiguration.map(value => value.buildAwsValue())
      )(_.errorReportConfiguration)
      .optionallyWith(lastRunSummary.map(value => value.buildAwsValue()))(
        _.lastRunSummary
      )
      .optionallyWith(
        recentlyFailedRuns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recentlyFailedRuns)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.ScheduledQueryDescription.ReadOnly =
    zio.aws.timestreamquery.model.ScheduledQueryDescription
      .wrap(buildAwsValue())
}
object ScheduledQueryDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.ScheduledQueryDescription =
      zio.aws.timestreamquery.model.ScheduledQueryDescription(
        arn,
        name,
        queryString,
        creationTime.map(value => value),
        state,
        previousInvocationTime.map(value => value),
        nextInvocationTime.map(value => value),
        scheduleConfiguration.asEditable,
        notificationConfiguration.asEditable,
        targetConfiguration.map(value => value.asEditable),
        scheduledQueryExecutionRoleArn.map(value => value),
        kmsKeyId.map(value => value),
        errorReportConfiguration.map(value => value.asEditable),
        lastRunSummary.map(value => value.asEditable),
        recentlyFailedRuns.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: AmazonResourceName
    def name: ScheduledQueryName
    def queryString: QueryString
    def creationTime: Option[Time]
    def state: zio.aws.timestreamquery.model.ScheduledQueryState
    def previousInvocationTime: Option[Time]
    def nextInvocationTime: Option[Time]
    def scheduleConfiguration
        : zio.aws.timestreamquery.model.ScheduleConfiguration.ReadOnly
    def notificationConfiguration
        : zio.aws.timestreamquery.model.NotificationConfiguration.ReadOnly
    def targetConfiguration
        : Option[zio.aws.timestreamquery.model.TargetConfiguration.ReadOnly]
    def scheduledQueryExecutionRoleArn: Option[AmazonResourceName]
    def kmsKeyId: Option[StringValue2048]
    def errorReportConfiguration: Option[
      zio.aws.timestreamquery.model.ErrorReportConfiguration.ReadOnly
    ]
    def lastRunSummary: Option[
      zio.aws.timestreamquery.model.ScheduledQueryRunSummary.ReadOnly
    ]
    def recentlyFailedRuns: Option[
      List[zio.aws.timestreamquery.model.ScheduledQueryRunSummary.ReadOnly]
    ]
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
    def getName: ZIO[Any, Nothing, ScheduledQueryName] = ZIO.succeed(name)
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getState
        : ZIO[Any, Nothing, zio.aws.timestreamquery.model.ScheduledQueryState] =
      ZIO.succeed(state)
    def getPreviousInvocationTime: ZIO[Any, AwsError, Time] = AwsError
      .unwrapOptionField("previousInvocationTime", previousInvocationTime)
    def getNextInvocationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("nextInvocationTime", nextInvocationTime)
    def getScheduleConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.timestreamquery.model.ScheduleConfiguration.ReadOnly
    ] = ZIO.succeed(scheduleConfiguration)
    def getNotificationConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.timestreamquery.model.NotificationConfiguration.ReadOnly
    ] = ZIO.succeed(notificationConfiguration)
    def getTargetConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.TargetConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("targetConfiguration", targetConfiguration)
    def getScheduledQueryExecutionRoleArn
        : ZIO[Any, AwsError, AmazonResourceName] = AwsError.unwrapOptionField(
      "scheduledQueryExecutionRoleArn",
      scheduledQueryExecutionRoleArn
    )
    def getKmsKeyId: ZIO[Any, AwsError, StringValue2048] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getErrorReportConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.ErrorReportConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "errorReportConfiguration",
      errorReportConfiguration
    )
    def getLastRunSummary: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.ScheduledQueryRunSummary.ReadOnly
    ] = AwsError.unwrapOptionField("lastRunSummary", lastRunSummary)
    def getRecentlyFailedRuns: ZIO[Any, AwsError, List[
      zio.aws.timestreamquery.model.ScheduledQueryRunSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("recentlyFailedRuns", recentlyFailedRuns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryDescription
  ) extends zio.aws.timestreamquery.model.ScheduledQueryDescription.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.timestreamquery.model.primitives.AmazonResourceName(impl.arn())
    override val name: ScheduledQueryName =
      zio.aws.timestreamquery.model.primitives.ScheduledQueryName(impl.name())
    override val queryString: QueryString =
      zio.aws.timestreamquery.model.primitives.QueryString(impl.queryString())
    override val creationTime: Option[Time] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.timestreamquery.model.primitives.Time(value))
    override val state: zio.aws.timestreamquery.model.ScheduledQueryState =
      zio.aws.timestreamquery.model.ScheduledQueryState.wrap(impl.state())
    override val previousInvocationTime: Option[Time] = scala
      .Option(impl.previousInvocationTime())
      .map(value => zio.aws.timestreamquery.model.primitives.Time(value))
    override val nextInvocationTime: Option[Time] = scala
      .Option(impl.nextInvocationTime())
      .map(value => zio.aws.timestreamquery.model.primitives.Time(value))
    override val scheduleConfiguration
        : zio.aws.timestreamquery.model.ScheduleConfiguration.ReadOnly =
      zio.aws.timestreamquery.model.ScheduleConfiguration
        .wrap(impl.scheduleConfiguration())
    override val notificationConfiguration
        : zio.aws.timestreamquery.model.NotificationConfiguration.ReadOnly =
      zio.aws.timestreamquery.model.NotificationConfiguration
        .wrap(impl.notificationConfiguration())
    override val targetConfiguration
        : Option[zio.aws.timestreamquery.model.TargetConfiguration.ReadOnly] =
      scala
        .Option(impl.targetConfiguration())
        .map(value =>
          zio.aws.timestreamquery.model.TargetConfiguration.wrap(value)
        )
    override val scheduledQueryExecutionRoleArn: Option[AmazonResourceName] =
      scala
        .Option(impl.scheduledQueryExecutionRoleArn())
        .map(value =>
          zio.aws.timestreamquery.model.primitives.AmazonResourceName(value)
        )
    override val kmsKeyId: Option[StringValue2048] = scala
      .Option(impl.kmsKeyId())
      .map(value =>
        zio.aws.timestreamquery.model.primitives.StringValue2048(value)
      )
    override val errorReportConfiguration: Option[
      zio.aws.timestreamquery.model.ErrorReportConfiguration.ReadOnly
    ] = scala
      .Option(impl.errorReportConfiguration())
      .map(value =>
        zio.aws.timestreamquery.model.ErrorReportConfiguration.wrap(value)
      )
    override val lastRunSummary: Option[
      zio.aws.timestreamquery.model.ScheduledQueryRunSummary.ReadOnly
    ] = scala
      .Option(impl.lastRunSummary())
      .map(value =>
        zio.aws.timestreamquery.model.ScheduledQueryRunSummary.wrap(value)
      )
    override val recentlyFailedRuns: Option[
      List[zio.aws.timestreamquery.model.ScheduledQueryRunSummary.ReadOnly]
    ] = scala
      .Option(impl.recentlyFailedRuns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.timestreamquery.model.ScheduledQueryRunSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryDescription
  ): zio.aws.timestreamquery.model.ScheduledQueryDescription.ReadOnly =
    new Wrapper(impl)
}
