package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.NextScheduledQueriesResultsToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListScheduledQueriesResponse(
    scheduledQueries: Iterable[zio.aws.timestreamquery.model.ScheduledQuery],
    nextToken: Option[NextScheduledQueriesResultsToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesResponse = {
    import ListScheduledQueriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesResponse
      .builder()
      .scheduledQueries(scheduledQueries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value =>
          NextScheduledQueriesResultsToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.ListScheduledQueriesResponse.ReadOnly =
    zio.aws.timestreamquery.model.ListScheduledQueriesResponse
      .wrap(buildAwsValue())
}
object ListScheduledQueriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.ListScheduledQueriesResponse =
      zio.aws.timestreamquery.model.ListScheduledQueriesResponse(
        scheduledQueries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def scheduledQueries
        : List[zio.aws.timestreamquery.model.ScheduledQuery.ReadOnly]
    def nextToken: Option[NextScheduledQueriesResultsToken]
    def getScheduledQueries: ZIO[Any, Nothing, List[
      zio.aws.timestreamquery.model.ScheduledQuery.ReadOnly
    ]] = ZIO.succeed(scheduledQueries)
    def getNextToken: ZIO[Any, AwsError, NextScheduledQueriesResultsToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesResponse
  ) extends zio.aws.timestreamquery.model.ListScheduledQueriesResponse.ReadOnly {
    override val scheduledQueries
        : List[zio.aws.timestreamquery.model.ScheduledQuery.ReadOnly] = impl
      .scheduledQueries()
      .asScala
      .map { item =>
        zio.aws.timestreamquery.model.ScheduledQuery.wrap(item)
      }
      .toList
    override val nextToken: Option[NextScheduledQueriesResultsToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.timestreamquery.model.primitives
          .NextScheduledQueriesResultsToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesResponse
  ): zio.aws.timestreamquery.model.ListScheduledQueriesResponse.ReadOnly =
    new Wrapper(impl)
}
