package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Type(
    scalarType: Optional[zio.aws.timestreamquery.model.ScalarType] =
      Optional.Absent,
    arrayColumnInfo: Optional[zio.aws.timestreamquery.model.ColumnInfo] =
      Optional.Absent,
    timeSeriesMeasureValueColumnInfo: Optional[
      zio.aws.timestreamquery.model.ColumnInfo
    ] = Optional.Absent,
    rowColumnInfo: Optional[
      Iterable[zio.aws.timestreamquery.model.ColumnInfo]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.Type = {
    import Type.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.Type
      .builder()
      .optionallyWith(scalarType.map(value => value.unwrap))(_.scalarType)
      .optionallyWith(arrayColumnInfo.map(value => value.buildAwsValue()))(
        _.arrayColumnInfo
      )
      .optionallyWith(
        timeSeriesMeasureValueColumnInfo.map(value => value.buildAwsValue())
      )(_.timeSeriesMeasureValueColumnInfo)
      .optionallyWith(
        rowColumnInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rowColumnInfo)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.Type.ReadOnly =
    zio.aws.timestreamquery.model.Type.wrap(buildAwsValue())
}
object Type {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.Type
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.Type =
      zio.aws.timestreamquery.model.Type(
        scalarType.map(value => value),
        arrayColumnInfo.map(value => value.asEditable),
        timeSeriesMeasureValueColumnInfo.map(value => value.asEditable),
        rowColumnInfo.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def scalarType: Optional[zio.aws.timestreamquery.model.ScalarType]
    def arrayColumnInfo
        : Optional[zio.aws.timestreamquery.model.ColumnInfo.ReadOnly]
    def timeSeriesMeasureValueColumnInfo
        : Optional[zio.aws.timestreamquery.model.ColumnInfo.ReadOnly]
    def rowColumnInfo
        : Optional[List[zio.aws.timestreamquery.model.ColumnInfo.ReadOnly]]
    def getScalarType
        : ZIO[Any, AwsError, zio.aws.timestreamquery.model.ScalarType] =
      AwsError.unwrapOptionField("scalarType", scalarType)
    def getArrayColumnInfo: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.ColumnInfo.ReadOnly
    ] = AwsError.unwrapOptionField("arrayColumnInfo", arrayColumnInfo)
    def getTimeSeriesMeasureValueColumnInfo: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.ColumnInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "timeSeriesMeasureValueColumnInfo",
      timeSeriesMeasureValueColumnInfo
    )
    def getRowColumnInfo: ZIO[Any, AwsError, List[
      zio.aws.timestreamquery.model.ColumnInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("rowColumnInfo", rowColumnInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.Type
  ) extends zio.aws.timestreamquery.model.Type.ReadOnly {
    override val scalarType
        : Optional[zio.aws.timestreamquery.model.ScalarType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalarType())
        .map(value => zio.aws.timestreamquery.model.ScalarType.wrap(value))
    override val arrayColumnInfo
        : Optional[zio.aws.timestreamquery.model.ColumnInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arrayColumnInfo())
        .map(value => zio.aws.timestreamquery.model.ColumnInfo.wrap(value))
    override val timeSeriesMeasureValueColumnInfo
        : Optional[zio.aws.timestreamquery.model.ColumnInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeSeriesMeasureValueColumnInfo())
        .map(value => zio.aws.timestreamquery.model.ColumnInfo.wrap(value))
    override val rowColumnInfo
        : Optional[List[zio.aws.timestreamquery.model.ColumnInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rowColumnInfo())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.timestreamquery.model.ColumnInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.Type
  ): zio.aws.timestreamquery.model.Type.ReadOnly = new Wrapper(impl)
}
