package zio.aws.timestreamquery.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.timestreamquery.model.primitives.{
  MaxQueryResults,
  PaginationToken,
  ClientRequestToken,
  QueryString
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class QueryRequest(
    queryString: QueryString,
    clientToken: Optional[ClientRequestToken] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxRows: Optional[MaxQueryResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.QueryRequest = {
    import QueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.QueryRequest
      .builder()
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .optionallyWith(
        clientToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxRows.map(value => MaxQueryResults.unwrap(value): Integer)
      )(_.maxRows)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.QueryRequest.ReadOnly =
    zio.aws.timestreamquery.model.QueryRequest.wrap(buildAwsValue())
}
object QueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.QueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.QueryRequest =
      zio.aws.timestreamquery.model.QueryRequest(
        queryString,
        clientToken.map(value => value),
        nextToken.map(value => value),
        maxRows.map(value => value)
      )
    def queryString: QueryString
    def clientToken: Optional[ClientRequestToken]
    def nextToken: Optional[PaginationToken]
    def maxRows: Optional[MaxQueryResults]
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getClientToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxRows: ZIO[Any, AwsError, MaxQueryResults] =
      AwsError.unwrapOptionField("maxRows", maxRows)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.QueryRequest
  ) extends zio.aws.timestreamquery.model.QueryRequest.ReadOnly {
    override val queryString: QueryString =
      zio.aws.timestreamquery.model.primitives.QueryString(impl.queryString())
    override val clientToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientToken())
        .map(value =>
          zio.aws.timestreamquery.model.primitives.ClientRequestToken(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.timestreamquery.model.primitives.PaginationToken(value)
      )
    override val maxRows: Optional[MaxQueryResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRows())
      .map(value =>
        zio.aws.timestreamquery.model.primitives.MaxQueryResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.QueryRequest
  ): zio.aws.timestreamquery.model.QueryRequest.ReadOnly = new Wrapper(impl)
}
