package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TargetDestination(
    timestreamDestination: Optional[
      zio.aws.timestreamquery.model.TimestreamDestination
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.TargetDestination = {
    import TargetDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.TargetDestination
      .builder()
      .optionallyWith(
        timestreamDestination.map(value => value.buildAwsValue())
      )(_.timestreamDestination)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.TargetDestination.ReadOnly =
    zio.aws.timestreamquery.model.TargetDestination.wrap(buildAwsValue())
}
object TargetDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.TargetDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.TargetDestination =
      zio.aws.timestreamquery.model
        .TargetDestination(timestreamDestination.map(value => value.asEditable))
    def timestreamDestination
        : Optional[zio.aws.timestreamquery.model.TimestreamDestination.ReadOnly]
    def getTimestreamDestination: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.TimestreamDestination.ReadOnly
    ] =
      AwsError.unwrapOptionField("timestreamDestination", timestreamDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.TargetDestination
  ) extends zio.aws.timestreamquery.model.TargetDestination.ReadOnly {
    override val timestreamDestination: Optional[
      zio.aws.timestreamquery.model.TimestreamDestination.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.timestreamDestination())
      .map(value =>
        zio.aws.timestreamquery.model.TimestreamDestination.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.TargetDestination
  ): zio.aws.timestreamquery.model.TargetDestination.ReadOnly = new Wrapper(
    impl
  )
}
