package zio.aws.timestreamquery
import zio.aws.timestreamquery.model.DescribeScheduledQueryResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.timestreamquery.model.primitives.QueryId
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.aws.timestreamquery.model.{
  ListScheduledQueriesRequest,
  DescribeEndpointsRequest,
  UpdateScheduledQueryRequest,
  CreateScheduledQueryRequest,
  ListTagsForResourceRequest,
  DescribeScheduledQueryRequest,
  QueryRequest,
  DeleteScheduledQueryRequest,
  UntagResourceRequest,
  ExecuteScheduledQueryRequest,
  CancelQueryRequest,
  TagResourceRequest,
  PrepareQueryRequest
}
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object TimestreamQueryMock extends Mock[TimestreamQuery] {
  object DeleteScheduledQuery
      extends Effect[DeleteScheduledQueryRequest, AwsError, Unit]
  object CreateScheduledQuery
      extends Effect[
        CreateScheduledQueryRequest,
        AwsError,
        zio.aws.timestreamquery.model.CreateScheduledQueryResponse.ReadOnly
      ]
  object UpdateScheduledQuery
      extends Effect[UpdateScheduledQueryRequest, AwsError, Unit]
  object PrepareQuery
      extends Effect[
        PrepareQueryRequest,
        AwsError,
        zio.aws.timestreamquery.model.PrepareQueryResponse.ReadOnly
      ]
  object Query
      extends Effect[QueryRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.timestreamquery.model.QueryResponse.ReadOnly,
        QueryId
      ]]
  object QueryPaginated
      extends Effect[
        QueryRequest,
        AwsError,
        zio.aws.timestreamquery.model.QueryResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.timestreamquery.model.UntagResourceResponse.ReadOnly
      ]
  object ExecuteScheduledQuery
      extends Effect[ExecuteScheduledQueryRequest, AwsError, Unit]
  object ListScheduledQueries
      extends Stream[
        ListScheduledQueriesRequest,
        AwsError,
        zio.aws.timestreamquery.model.ScheduledQuery.ReadOnly
      ]
  object ListScheduledQueriesPaginated
      extends Effect[
        ListScheduledQueriesRequest,
        AwsError,
        zio.aws.timestreamquery.model.ListScheduledQueriesResponse.ReadOnly
      ]
  object DescribeEndpoints
      extends Effect[
        DescribeEndpointsRequest,
        AwsError,
        zio.aws.timestreamquery.model.DescribeEndpointsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.timestreamquery.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.timestreamquery.model.ListTagsForResourceResponse.ReadOnly
      ]
  object CancelQuery
      extends Effect[
        CancelQueryRequest,
        AwsError,
        zio.aws.timestreamquery.model.CancelQueryResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.timestreamquery.model.TagResourceResponse.ReadOnly
      ]
  object DescribeScheduledQuery
      extends Effect[DescribeScheduledQueryRequest, AwsError, ReadOnly]
  val compose: URLayer[Proxy, TimestreamQuery] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, TimestreamQuery] { rts =>
        zio.ZIO.succeed {
          new TimestreamQuery {
            val api: TimestreamQueryAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): TimestreamQuery = this
            def deleteScheduledQuery(
                request: DeleteScheduledQueryRequest
            ): IO[AwsError, Unit] = proxy(DeleteScheduledQuery, request)
            def createScheduledQuery(request: CreateScheduledQueryRequest): IO[
              AwsError,
              zio.aws.timestreamquery.model.CreateScheduledQueryResponse.ReadOnly
            ] = proxy(CreateScheduledQuery, request)
            def updateScheduledQuery(
                request: UpdateScheduledQueryRequest
            ): IO[AwsError, Unit] = proxy(UpdateScheduledQuery, request)
            def prepareQuery(request: PrepareQueryRequest): IO[
              AwsError,
              zio.aws.timestreamquery.model.PrepareQueryResponse.ReadOnly
            ] = proxy(PrepareQuery, request)
            def query(
                request: QueryRequest
            ): IO[AwsError, StreamingOutputResult[
              Any,
              zio.aws.timestreamquery.model.QueryResponse.ReadOnly,
              QueryId
            ]] = proxy(Query, request)
            def queryPaginated(request: QueryRequest): IO[
              AwsError,
              zio.aws.timestreamquery.model.QueryResponse.ReadOnly
            ] = proxy(QueryPaginated, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.timestreamquery.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def executeScheduledQuery(
                request: ExecuteScheduledQueryRequest
            ): IO[AwsError, Unit] = proxy(ExecuteScheduledQuery, request)
            def listScheduledQueries(
                request: ListScheduledQueriesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.timestreamquery.model.ScheduledQuery.ReadOnly
            ] = rts.unsafeRun(proxy(ListScheduledQueries, request))
            def listScheduledQueriesPaginated(
                request: ListScheduledQueriesRequest
            ): IO[
              AwsError,
              zio.aws.timestreamquery.model.ListScheduledQueriesResponse.ReadOnly
            ] = proxy(ListScheduledQueriesPaginated, request)
            def describeEndpoints(request: DescribeEndpointsRequest): IO[
              AwsError,
              zio.aws.timestreamquery.model.DescribeEndpointsResponse.ReadOnly
            ] = proxy(DescribeEndpoints, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.timestreamquery.model.Tag.ReadOnly
            ] = rts.unsafeRun(proxy(ListTagsForResource, request))
            def listTagsForResourcePaginated(
                request: ListTagsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.timestreamquery.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResourcePaginated, request)
            def cancelQuery(request: CancelQueryRequest): IO[
              AwsError,
              zio.aws.timestreamquery.model.CancelQueryResponse.ReadOnly
            ] = proxy(CancelQuery, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.timestreamquery.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def describeScheduledQuery(
                request: DescribeScheduledQueryRequest
            ): IO[AwsError, ReadOnly] = proxy(DescribeScheduledQuery, request)
          }
        }
      }
    }
  }
}
