package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.AmazonResourceName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeScheduledQueryRequest(
    scheduledQueryArn: AmazonResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryRequest = {
    import DescribeScheduledQueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryRequest
      .builder()
      .scheduledQueryArn(
        AmazonResourceName.unwrap(scheduledQueryArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.DescribeScheduledQueryRequest.ReadOnly =
    zio.aws.timestreamquery.model.DescribeScheduledQueryRequest
      .wrap(buildAwsValue())
}
object DescribeScheduledQueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.timestreamquery.model.DescribeScheduledQueryRequest =
      zio.aws.timestreamquery.model
        .DescribeScheduledQueryRequest(scheduledQueryArn)
    def scheduledQueryArn: AmazonResourceName
    def getScheduledQueryArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(scheduledQueryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryRequest
  ) extends zio.aws.timestreamquery.model.DescribeScheduledQueryRequest.ReadOnly {
    override val scheduledQueryArn: AmazonResourceName =
      zio.aws.timestreamquery.model.primitives
        .AmazonResourceName(impl.scheduledQueryArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryRequest
  ): zio.aws.timestreamquery.model.DescribeScheduledQueryRequest.ReadOnly =
    new Wrapper(impl)
}
