package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.Timestamp
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TimeSeriesDataPoint(
    time: Timestamp,
    value: zio.aws.timestreamquery.model.Datum
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.TimeSeriesDataPoint = {
    import TimeSeriesDataPoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.TimeSeriesDataPoint
      .builder()
      .time(Timestamp.unwrap(time): java.lang.String)
      .value(value.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.TimeSeriesDataPoint.ReadOnly =
    zio.aws.timestreamquery.model.TimeSeriesDataPoint.wrap(buildAwsValue())
}
object TimeSeriesDataPoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.TimeSeriesDataPoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.TimeSeriesDataPoint =
      zio.aws.timestreamquery.model.TimeSeriesDataPoint(time, value.asEditable)
    def time: Timestamp
    def value: zio.aws.timestreamquery.model.Datum.ReadOnly
    def getTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(time)
    def getValue
        : ZIO[Any, Nothing, zio.aws.timestreamquery.model.Datum.ReadOnly] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.TimeSeriesDataPoint
  ) extends zio.aws.timestreamquery.model.TimeSeriesDataPoint.ReadOnly {
    override val time: Timestamp =
      zio.aws.timestreamquery.model.primitives.Timestamp(impl.time())
    override val value: zio.aws.timestreamquery.model.Datum.ReadOnly =
      zio.aws.timestreamquery.model.Datum.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.TimeSeriesDataPoint
  ): zio.aws.timestreamquery.model.TimeSeriesDataPoint.ReadOnly = new Wrapper(
    impl
  )
}
