package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.{
  Time,
  ScheduledQueryName,
  AmazonResourceName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ScheduledQuery(
    arn: AmazonResourceName,
    name: ScheduledQueryName,
    creationTime: Option[Time] = None,
    state: zio.aws.timestreamquery.model.ScheduledQueryState,
    previousInvocationTime: Option[Time] = None,
    nextInvocationTime: Option[Time] = None,
    errorReportConfiguration: Option[
      zio.aws.timestreamquery.model.ErrorReportConfiguration
    ] = None,
    targetDestination: Option[zio.aws.timestreamquery.model.TargetDestination] =
      None,
    lastRunStatus: Option[
      zio.aws.timestreamquery.model.ScheduledQueryRunStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.ScheduledQuery = {
    import ScheduledQuery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.ScheduledQuery
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .name(ScheduledQueryName.unwrap(name): java.lang.String)
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .state(state.unwrap)
      .optionallyWith(
        previousInvocationTime.map(value => Time.unwrap(value): Instant)
      )(_.previousInvocationTime)
      .optionallyWith(
        nextInvocationTime.map(value => Time.unwrap(value): Instant)
      )(_.nextInvocationTime)
      .optionallyWith(
        errorReportConfiguration.map(value => value.buildAwsValue())
      )(_.errorReportConfiguration)
      .optionallyWith(targetDestination.map(value => value.buildAwsValue()))(
        _.targetDestination
      )
      .optionallyWith(lastRunStatus.map(value => value.unwrap))(_.lastRunStatus)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.ScheduledQuery.ReadOnly =
    zio.aws.timestreamquery.model.ScheduledQuery.wrap(buildAwsValue())
}
object ScheduledQuery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.ScheduledQuery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.ScheduledQuery =
      zio.aws.timestreamquery.model.ScheduledQuery(
        arn,
        name,
        creationTime.map(value => value),
        state,
        previousInvocationTime.map(value => value),
        nextInvocationTime.map(value => value),
        errorReportConfiguration.map(value => value.asEditable),
        targetDestination.map(value => value.asEditable),
        lastRunStatus.map(value => value)
      )
    def arn: AmazonResourceName
    def name: ScheduledQueryName
    def creationTime: Option[Time]
    def state: zio.aws.timestreamquery.model.ScheduledQueryState
    def previousInvocationTime: Option[Time]
    def nextInvocationTime: Option[Time]
    def errorReportConfiguration: Option[
      zio.aws.timestreamquery.model.ErrorReportConfiguration.ReadOnly
    ]
    def targetDestination
        : Option[zio.aws.timestreamquery.model.TargetDestination.ReadOnly]
    def lastRunStatus
        : Option[zio.aws.timestreamquery.model.ScheduledQueryRunStatus]
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
    def getName: ZIO[Any, Nothing, ScheduledQueryName] = ZIO.succeed(name)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getState
        : ZIO[Any, Nothing, zio.aws.timestreamquery.model.ScheduledQueryState] =
      ZIO.succeed(state)
    def getPreviousInvocationTime: ZIO[Any, AwsError, Time] = AwsError
      .unwrapOptionField("previousInvocationTime", previousInvocationTime)
    def getNextInvocationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("nextInvocationTime", nextInvocationTime)
    def getErrorReportConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.ErrorReportConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "errorReportConfiguration",
      errorReportConfiguration
    )
    def getTargetDestination: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.TargetDestination.ReadOnly
    ] = AwsError.unwrapOptionField("targetDestination", targetDestination)
    def getLastRunStatus: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.ScheduledQueryRunStatus
    ] = AwsError.unwrapOptionField("lastRunStatus", lastRunStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.ScheduledQuery
  ) extends zio.aws.timestreamquery.model.ScheduledQuery.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.timestreamquery.model.primitives.AmazonResourceName(impl.arn())
    override val name: ScheduledQueryName =
      zio.aws.timestreamquery.model.primitives.ScheduledQueryName(impl.name())
    override val creationTime: Option[Time] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.timestreamquery.model.primitives.Time(value))
    override val state: zio.aws.timestreamquery.model.ScheduledQueryState =
      zio.aws.timestreamquery.model.ScheduledQueryState.wrap(impl.state())
    override val previousInvocationTime: Option[Time] = scala
      .Option(impl.previousInvocationTime())
      .map(value => zio.aws.timestreamquery.model.primitives.Time(value))
    override val nextInvocationTime: Option[Time] = scala
      .Option(impl.nextInvocationTime())
      .map(value => zio.aws.timestreamquery.model.primitives.Time(value))
    override val errorReportConfiguration: Option[
      zio.aws.timestreamquery.model.ErrorReportConfiguration.ReadOnly
    ] = scala
      .Option(impl.errorReportConfiguration())
      .map(value =>
        zio.aws.timestreamquery.model.ErrorReportConfiguration.wrap(value)
      )
    override val targetDestination
        : Option[zio.aws.timestreamquery.model.TargetDestination.ReadOnly] =
      scala
        .Option(impl.targetDestination())
        .map(value =>
          zio.aws.timestreamquery.model.TargetDestination.wrap(value)
        )
    override val lastRunStatus
        : Option[zio.aws.timestreamquery.model.ScheduledQueryRunStatus] = scala
      .Option(impl.lastRunStatus())
      .map(value =>
        zio.aws.timestreamquery.model.ScheduledQueryRunStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.ScheduledQuery
  ): zio.aws.timestreamquery.model.ScheduledQuery.ReadOnly = new Wrapper(impl)
}
