package zio.aws.timestreamquery.model
import scala.jdk.CollectionConverters._
sealed trait ScalarMeasureValueType {
  def unwrap: software.amazon.awssdk.services.timestreamquery.model.ScalarMeasureValueType
}
object ScalarMeasureValueType {
  def wrap(
      value: software.amazon.awssdk.services.timestreamquery.model.ScalarMeasureValueType
  ): zio.aws.timestreamquery.model.ScalarMeasureValueType = value match {
    case software.amazon.awssdk.services.timestreamquery.model.ScalarMeasureValueType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.timestreamquery.model.ScalarMeasureValueType.BIGINT =>
      val r = BIGINT
      r
    case software.amazon.awssdk.services.timestreamquery.model.ScalarMeasureValueType.BOOLEAN =>
      val r = BOOLEAN
      r
    case software.amazon.awssdk.services.timestreamquery.model.ScalarMeasureValueType.DOUBLE =>
      val r = DOUBLE
      r
    case software.amazon.awssdk.services.timestreamquery.model.ScalarMeasureValueType.VARCHAR =>
      val r = VARCHAR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.timestreamquery.model.ScalarMeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.ScalarMeasureValueType =
      software.amazon.awssdk.services.timestreamquery.model.ScalarMeasureValueType.UNKNOWN_TO_SDK_VERSION
  }
  case object BIGINT
      extends zio.aws.timestreamquery.model.ScalarMeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.ScalarMeasureValueType =
      software.amazon.awssdk.services.timestreamquery.model.ScalarMeasureValueType.BIGINT
  }
  case object BOOLEAN
      extends zio.aws.timestreamquery.model.ScalarMeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.ScalarMeasureValueType =
      software.amazon.awssdk.services.timestreamquery.model.ScalarMeasureValueType.BOOLEAN
  }
  case object DOUBLE
      extends zio.aws.timestreamquery.model.ScalarMeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.ScalarMeasureValueType =
      software.amazon.awssdk.services.timestreamquery.model.ScalarMeasureValueType.DOUBLE
  }
  case object VARCHAR
      extends zio.aws.timestreamquery.model.ScalarMeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.ScalarMeasureValueType =
      software.amazon.awssdk.services.timestreamquery.model.ScalarMeasureValueType.VARCHAR
  }
}
