package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.SchemaName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MultiMeasureAttributeMapping(
    sourceColumn: SchemaName,
    targetMultiMeasureAttributeName: Option[SchemaName] = None,
    measureValueType: zio.aws.timestreamquery.model.ScalarMeasureValueType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.MultiMeasureAttributeMapping = {
    import MultiMeasureAttributeMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.MultiMeasureAttributeMapping
      .builder()
      .sourceColumn(SchemaName.unwrap(sourceColumn): java.lang.String)
      .optionallyWith(
        targetMultiMeasureAttributeName.map(value =>
          SchemaName.unwrap(value): java.lang.String
        )
      )(_.targetMultiMeasureAttributeName)
      .measureValueType(measureValueType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.MultiMeasureAttributeMapping.ReadOnly =
    zio.aws.timestreamquery.model.MultiMeasureAttributeMapping
      .wrap(buildAwsValue())
}
object MultiMeasureAttributeMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.MultiMeasureAttributeMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.MultiMeasureAttributeMapping =
      zio.aws.timestreamquery.model.MultiMeasureAttributeMapping(
        sourceColumn,
        targetMultiMeasureAttributeName.map(value => value),
        measureValueType
      )
    def sourceColumn: SchemaName
    def targetMultiMeasureAttributeName: Option[SchemaName]
    def measureValueType: zio.aws.timestreamquery.model.ScalarMeasureValueType
    def getSourceColumn: ZIO[Any, Nothing, SchemaName] =
      ZIO.succeed(sourceColumn)
    def getTargetMultiMeasureAttributeName: ZIO[Any, AwsError, SchemaName] =
      AwsError.unwrapOptionField(
        "targetMultiMeasureAttributeName",
        targetMultiMeasureAttributeName
      )
    def getMeasureValueType: ZIO[
      Any,
      Nothing,
      zio.aws.timestreamquery.model.ScalarMeasureValueType
    ] = ZIO.succeed(measureValueType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.MultiMeasureAttributeMapping
  ) extends zio.aws.timestreamquery.model.MultiMeasureAttributeMapping.ReadOnly {
    override val sourceColumn: SchemaName =
      zio.aws.timestreamquery.model.primitives.SchemaName(impl.sourceColumn())
    override val targetMultiMeasureAttributeName: Option[SchemaName] = scala
      .Option(impl.targetMultiMeasureAttributeName())
      .map(value => zio.aws.timestreamquery.model.primitives.SchemaName(value))
    override val measureValueType
        : zio.aws.timestreamquery.model.ScalarMeasureValueType =
      zio.aws.timestreamquery.model.ScalarMeasureValueType
        .wrap(impl.measureValueType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.MultiMeasureAttributeMapping
  ): zio.aws.timestreamquery.model.MultiMeasureAttributeMapping.ReadOnly =
    new Wrapper(impl)
}
